#ifndef LIBRARIES_TESTS_RADIO_TERMINAL_RADIOCONTEX_H_
#define LIBRARIES_TESTS_RADIO_TERMINAL_RADIOCONTEX_H_

#include "sx1272-hal.h"
#include <string>

class Settings;

class RadioContex
{
private:
    static const char* rx_error_msg;
    static const char* rx_timeout_msg;
    int sendCntr;
public:

    enum
    {
        BUFFER_SIZE = 32        // Define the payload size here
    };

    RadioContex (Settings* settings);
    ~RadioContex ();

    Radio& radio();


public:
    SX1272BRD* radio_;

    static RadioContex* thi;


    typedef RadioState States_t;
    volatile States_t State;



    uint8_t Buffer[BUFFER_SIZE];

    int16_t RssiValue;
    int8_t SnrValue;
    uint16_t BufferSize;


    States_t getState() const;
    bool setState(States_t);



    bool Send(std::string arg);
    bool initReceive();
    bool pool_rx();



    static void StaticOnTxDone( void );
    static void StaticOnRxDone( uint8_t *payload, uint16_t size, int16_t rssi, int8_t snr);
    static void StaticOnTxTimeout( void );
    static void StaticOnRxTimeout( void );
    static void StaticOnRxError( void );


    void OnTxDone( void );
    void OnRxDone( uint8_t *payload, uint16_t size, int16_t rssi, int8_t snr);
    void OnTxTimeout( void );
    void OnRxTimeout( void );
    void OnRxError( void );
};

#endif /* LIBRARIES_TESTS_RADIO_TERMINAL_RADIOCONTEX_H_ */
