#include <cstdlib>
#include "SetVariableCmd.h"
#include "dbg.h"
#include "Settings.h"

SetVariableCmd::SetVariableCmd(Settings* settings)
    : Cmd()
    , settings_(settings)
{
}

SetVariableCmd::~SetVariableCmd()
{
}

string SetVariableCmd::cmd()
{
    return "sv";
}

string SetVariableCmd::desc()
{
    return "sets variables - sv [variable1 value1 [variable2 value2 [....]]]";
}

bool SetVariableCmd::execute(list<string> args)
{
    if (args.empty())
    {
        printf("%s\r\n", settings_->help().c_str());
    }

    for (list<string>::const_iterator p = args.begin(); p != args.end(); ++p)
    {
        const string value = *p;
        ++p;
        if (p == args.end())
        {
            printf("no value for %s\r\n", value.c_str());
            printf("%s\r\n", settings_->help(value).c_str());
            return false;
        }

        if (!settings_->set(value, atoi((*p).c_str())))
        {
            printf("bad value for %s\r\n", value.c_str());
            printf("%s\r\n", settings_->help(value).c_str());
            return false;
        }

        printf("set %s\r\n", settings_->describe(value).c_str());
    }
    return true;
}

string SetVariableCmd::getResponse(void)
{
    return "";
}

