#ifndef _CMDLIST_H_
#define _CMDLIST_H_

#include "PingPongCmd.h"
#include "SetVariableCmd.h"
#include "GetVariableCmd.h"
#include "GetRegisterCmd.h"
#include "TxCmd.h"
#include "RxCmd.h"
#include "HelpCmd.h"

/** Command type list entry
 *
 *  @param T type
 *  @param Tnext next list entry (L or int as end)
 */
template <typename T, typename Tnext>
struct L
{
    typedef T t;
    typedef Tnext tn;
};

/** type encapsulating all commands (for HelpCmd & CmdFactory )
 */
typedef
    L<HelpCmd,
    L<GetRegisterCmd,
    L<TxCmd,
    L<RxCmd,
    L<PingPongCmd,
    L<SetVariableCmd,
    L<GetVariableCmd,
    int > > > > > > > CmdList;

#endif

