#ifndef _CMDFACTORY_H_
#define _CMDFACTORY_H_

#include <string>
#include "mbed.h"
#include "Serial.h"

class Cmd;
class Settings;

class CmdFactory
{
    public:
        CmdFactory(Settings* settings, Serial* serial);
        ~CmdFactory();
        Cmd* createCmd(std::string cmd) const;
        
    private:

        /** Command builder
         *
         * @param cmds list of commands for which help will be shown.
         * @param cmd command mnemonic
         *
         * @see CmdList
         */
        template <typename cmds>
        Cmd* create(const std::string& cmd) const;

        Settings* settings_;
        Serial* serial_;
};

#endif
