#include "mbed.h"
#include "Serial.h"

#include "CmdFactory.h"
#include "CmdList.h"

CmdFactory::CmdFactory(Settings* settings, Serial *serial)
    : settings_(settings), serial_(serial)
{
}

CmdFactory::~CmdFactory()
{
}


template <>
Cmd* CmdFactory::create<int>(const std::string& cmd) const
{
    return NULL;
}

template <typename cmds>
Cmd* CmdFactory::create(const std::string& cmd) const
{
    typedef typename cmds::t T;

    if (0 == cmd.compare(T::cmd()))
    {
        return new T(settings_);
    }

    return create<typename cmds::tn>(cmd); // tail call recursion - optimized out (-O2)
}

Cmd* CmdFactory::createCmd(std::string cmd) const
{
    Cmd* command  = create<CmdList>(cmd);
    if (!command)
    {
        serial_->printf("No such command %s\r\n", cmd.c_str());
    }

    return command;
}
