/**
  ******************************************************************************
  * @file    ble_uart.cpp
  * @author  Happiesstminds Firmware Team
  * @version v1.0
  * @date    4-Oct-2016
  * @brief   
  *
  ******************************************************************************
  * @attention
  *  
  *
  ******************************************************************************
  */
 
/******************************************************************************/
/* Include Files*/
/******************************************************************************/
#include "mbed.h"
#include "spi_slave.h"
#include "ble_types.h"
#include "ble_msg_handler.h"
 
 
/******************************************************************************/
/* Local Defines                                                              */
/******************************************************************************/
#define SPI_DUMMY_BYTE      0x00
#define SPI_TX_EMPTY_DATA   0xFF
 
/******************************************************************************/
/* Extern Variable/functions                                                  */
/******************************************************************************/
extern bool toggle_led_flag;
extern void spi_rx_Data_Callback(uint8_t *rx_data);
 
/******************************************************************************/
/* Static Variables                                                           */
/******************************************************************************/
DigitalOut led2(LED1); 
SPISlave device(P0_9, P0_11,P0_8, P0_10); // mosi, miso, sclk, ssel

 
static spi_data_ready_callback_t  spi_data_ready_cb; 
 
uint8_t spi_tx_buf[SPI_TX_BUF_SIZE];
uint8_t spi_tx_ptr;
uint8_t spi_bytes_to_send;

/******************************************************************************/
/* Global Functions                                                              */
/******************************************************************************/
/**
 * @brief  Initializes the Nano BLE SPI slave buffer init
 * @param  None        
 * @retval None
 */
void spi_buf_init(void)
{   
    spi_tx_ptr = 0;
    spi_bytes_to_send = 0;
    memset(spi_tx_buf, SPI_TX_EMPTY_DATA, SPI_TX_BUF_SIZE);
}
 
/**
 * @brief  Receive data from Master
 * @param  
 * @retval 
 */
void spi_slave_rx_data(void)
{    
    uint8_t rx_buf[SPI_TX_BUF_SIZE];
    uint8_t byte_cnt = 0;
    uint8_t send_ptr = 0;
    
    device.reply(0xFF);
    while(1)
    {
        if(device.receive()) 
        {            
            rx_buf[byte_cnt] = device.read();
            
            if (spi_bytes_to_send > 0) {
                //device.reply(rx_buf[byte_cnt]);
                device.reply(spi_tx_buf[send_ptr++]);                
             //   if (spi_tx_ptr++ > SPI_TX_BUF_SIZE) {
             //       spi_tx_ptr= 0;
             //   }
                spi_bytes_to_send--;
                if(spi_bytes_to_send ==0)
                {
                    send_ptr = 0;
                    /*read compleated*/
                }
            } else {
                device.reply(SPI_TX_EMPTY_DATA);
            } 
            
            if ((byte_cnt >= 4) && (rx_buf[byte_cnt] == BLE_EOT_CMD)) {                
                /* Check for End of Frame to make sure complete packet has been received */
                spi_data_ready_cb(rx_buf);
                byte_cnt = 0;
            }
            byte_cnt++;
        }
    } 
}
 
/**
 * @brief  Send data to Master
 * @param  
 * @retval 
 */
void spi_slave_tx_data(uint8_t *tx_buf, uint8_t len)
{
    spi_tx_ptr = 0;
    spi_bytes_to_send = 0;   
    /* Copy the buffer into local buffer */
    memcpy(&spi_tx_buf[spi_tx_ptr], tx_buf, len);
    spi_bytes_to_send += len; 
    spi_tx_ptr += len; 
    if (spi_tx_ptr > SPI_TX_BUF_SIZE) {
        spi_tx_ptr = 0;    
    }
   
}
 
/**
 * @brief  Function used to register spi data receive callback 
 * @param  none
 * @retval none
 */
void spi_data_rx_cb_register(spi_data_ready_callback_t data_rx_callback)
{
    spi_data_ready_cb = data_rx_callback;
}
/******************************************************************************/
/* END OF FILE                                                                */
/******************************************************************************/