/**
  ******************************************************************************
  * @file    Main.cpp
  * @author  Happiesstminds Firmware Team
  * @version v1.0
  * @date    4-Oct-2016
  * @brief   
  *
  ******************************************************************************
  * @attention
  *  
  *
  ******************************************************************************
  */

/******************************************************************************/
/* Include Files*/
/******************************************************************************/
#include <string.h>
#include "mbed.h"
#include "BLE.h"
#include "UARTService.h"
#include "ble_types.h"
/******************************************************************************/
/* Local Defines                                                              */
/******************************************************************************/
#define NEED_CONSOLE_OUTPUT 0 /* Set this if you need debug messages on the console;
                               * it will have an impact on code-size and power consumption. */

#if NEED_CONSOLE_OUTPUT
#define DEBUG(STR) { if (uart) uart->write(STR, strlen(STR)); }
#else
#define DEBUG(...) /* nothing */
#endif /* #if NEED_CONSOLE_OUTPUT */

/******************************************************************************/
/* Extern Function declarations */
/******************************************************************************/
extern void spi_buf_init(void);
extern void ble_event_wait(void);
extern void ble_init(uint8_t *tx_buf, uint8_t length);
extern void ble_data_handler_init(void);
extern void spi_slave_rx_data(void);
extern void spi_dummy_test(void);
void init_interrupt_line(void );
/******************************************************************************/
/* External Variable Declarations */
/******************************************************************************/
extern bool isDeviceConnected;

/******************************************************************************/
/* Static Variable Declarations */
/******************************************************************************/
DigitalOut led1(LED1);
uint8_t spi_ble_array[20];
uint8_t spi_slave_test_rx_data(uint8_t * rx_buf);
/******************************************************************************/
/* Static Functions */
/******************************************************************************/
/**
 * @brief  Function Toggles the LED State
 * @param  
 * @retval 
 */
void toggle_led(void)
{    
    led1 = !led1;    
}

/******************************************************************************/
/* Global Functions */
/******************************************************************************/
/**
 * @brief  Main - entry point to the application
 * @param  
 * @retval 
 */ 
int main(void)
{
    /* LED init */
    led1 = true;           
    toggle_led();
    spi_buf_init();
    
    ble_data_handler_init();
    
    // Infinite loop, never exits
    while (true) 
    {
        //ble_event_wait();
        spi_slave_rx_data();        
    }
}
/******************************************************************************/
/* END OF FILE                                                                */
/******************************************************************************/