/**
  ******************************************************************************
  * @file    ble_uart.cpp
  * @author  Happiesstminds Firmware Team
  * @version v1.0
  * @date    4-Oct-2016
  * @brief   
  *
  ******************************************************************************
  * @attention
  *  
  *
  ******************************************************************************
  */
 
/******************************************************************************/
/* Include Files*/
/******************************************************************************/
#include <string.h>
#include "mbed.h"
#include "BLE.h"
#include "ble_types.h"
#include "spi_slave.h"
#include "UARTService.h"
#include "ble_gap.h"
/******************************************************************************/
/* Local Defines                                                              */
/******************************************************************************/
#define DEBUG(STR) { if (uart) uart->write(STR, strlen(STR)); }
//const static uint8_t AdvData[] = {"advdata"}; 
const static uint8_t LocName[] ={"EcolabICE"};
/******************************************************************************/
/* Global Variables                                                           */
/******************************************************************************/
 extern void enable_interrupt_line(bool status,uint8_t pin_num );
void spi_slave_tx_data(uint8_t *tx_buf, uint8_t len);
bool isDeviceConnected = false;
bool init_success =false;
 
#define DEBUG(STR) { if (uart) uart->write(STR, strlen(STR)); }
 
/******************************************************************************/
/* Static Variable Declarations */
/******************************************************************************/
static BLEDevice  ble;
static UARTService *uart;
static ble_data_ready_callback_t data_ready_cb;
 
/******************************************************************************/
/* Static Functions                                                           */
/******************************************************************************/
/**
 * @brief  Device Connection callback
 * @param  
 * @retval 
 */
static void ble_connectionCallback(const Gap::ConnectionCallbackParams_t *params)
{    
    uint8_t tx_buf[4];
    tx_buf[0] = 0x01;
    tx_buf[1] = 0xA3;
    tx_buf[2] = 0x00;
    tx_buf[3] = 0x04;
    spi_slave_tx_data(tx_buf, 4);
    isDeviceConnected = true;
    toggle_led();
}
 
/**
 * @brief  Device disconnection callback
 * @param  
 * @retval 
 */
static void ble_disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{    
    uint8_t tx_buf[4];
    tx_buf[0] = 0x01;
    tx_buf[1] = 0xA8;
    tx_buf[2] = 0x00;
    tx_buf[3] = 0x04;
    spi_slave_tx_data(tx_buf, 4);    
    isDeviceConnected = false;
    ble.startAdvertising();
}
 
/**
 * @brief  onDataWrittenCallback - On data received callback???
 * @param  
 * @retval 
 */
eStatus_t ble_send_data(uint8_t *tx_buf, uint8_t length);
 
static void ble_dataReceiveCallback(const GattWriteCallbackParams *params)                         
{    
    uint8_t buf[SPI_TX_BUF_SIZE] = {0};
    if(params->len<=SPI_TX_BUF_SIZE)
    {
        memcpy(buf, params->data, params->len);
        data_ready_cb(buf, params->len);
    }
}
 
/******************************************************************************/
/* Global Functions                                                           */
/******************************************************************************/
void print(const char *msg)
{
    DEBUG(msg);
}
/**
 * @brief  Initializes the BLE module
 * @param  none
 * @retval none
 */
void ble_init(uint8_t *tx_buf, uint8_t length)
{    
    ble.init();
    ble.onConnection(ble_connectionCallback);
    ble.onDisconnection(ble_disconnectionCallback);
    ble.onDataWritten(ble_dataReceiveCallback);
 
    uart = new UARTService(ble);

    ble_gap_conn_sec_mode_t sec_mode;

    BLE_GAP_CONN_SEC_MODE_SET_OPEN(&sec_mode);
    sd_ble_gap_device_name_set(&sec_mode,(const uint8_t *)tx_buf,length);
  
    /* Setup advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
//    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME,
//                                     (const uint8_t *)tx_buf, length);
//  ble.accumulateAdvertisingPayload(GapAdvertisingData::INCOMPLETE_LIST_128BIT_SERVICE_IDS,
//                                  (const uint8_t *)UARTServiceUUID_reversed, sizeof(UARTServiceUUID_reversed));
//  ble.accumulateAdvertisingPayload(GapAdvertisingData::INCOMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));    
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,LocName, sizeof(LocName));                           
    ble.setAdvertisingInterval(160); /* 100ms; in multiples of 0.625ms. */
    ble.startAdvertising();
    
    init_success=true;
}
 
/**
 * @brief  Function used to register ble data receive callback 
 * @param  none
 * @retval none
 */
void ble_data_rx_cb_register(ble_data_ready_callback_t data_rx_callback)
{
    data_ready_cb = data_rx_callback;
}
 
/**
 * @brief  Send data over BLE UART
 * @param  
 * @retval 
 */
eStatus_t ble_send_data(uint8_t *tx_buf, uint8_t length)
{
    eStatus_t ret_code = eSuccess;
    if (isDeviceConnected) {
        uart->write(tx_buf, length);
    } else {
        ret_code = eFailure;
    }
    return ret_code;
}
 
/**
 * @brief  Wait for the BLE events
 * @param  
 * @retval 
 */
void ble_event_wait(void)
{
    ble.waitForEvent();
}
 
/******************************************************************************/
/* END OF FILE                                                                */
/******************************************************************************/
 