/**
  ******************************************************************************
  * @file    ble_msg_handler.cpp
  * @author  Happiesstminds Firmware Team
  * @version v1.0
  * @date    4-Oct-2016
  * @brief   
  *
  ******************************************************************************
  * @attention
  *  
  *
  ******************************************************************************
  */

/******************************************************************************/
/* Include Files*/
/******************************************************************************/
#include <string.h>
#include "mbed.h"
#include "BLE.h"
#include "ble_types.h"
#include "UARTService.h"
#include "ble_msg_handler.h"
#include "spi_slave.h"
/******************************************************************************/
/* extern function definations                                                */
/******************************************************************************/
extern void ble_data_rx_cb_register(ble_data_ready_callback_t data_rx_callback);
extern void spi_data_rx_cb_register(spi_data_ready_callback_t data_rx_callback);
extern eStatus_t ble_send_data(uint8_t *tx_buf, uint8_t length);
extern void ble_init(uint8_t *tx_buf, uint8_t length);
extern void spi_slave_tx_data(uint8_t *tx_buf, uint8_t len);

/******************************************************************************/
/* Global Variables                                                           */
/******************************************************************************/
extern bool init_success;
/******************************************************************************/
/* Static Variable Declarations */
/******************************************************************************/

/******************************************************************************/
/* Static Functions                                                           */
/******************************************************************************/
/**
 * @brief  BLE_UART data Receive Callback
 * @param  
 * @retval 
 */
static void ble_rx_Data_Callback(uint8_t *rx_data, uint8_t len)
{
    uint8_t send_buf[SPI_TX_BUF_SIZE];
             
    send_buf[0] = BLE_SOF_CMD;
    send_buf[1] = rx_data[0];       
    send_buf[2] = len+4;  
    memcpy(&send_buf[3], &rx_data[1], (len-1));
    send_buf[len + 3] = BLE_EOT_CMD;    
    spi_slave_tx_data(send_buf, (len + 4));
}


/**
 * @brief  SPI data Receive Callback
 * @param  
 * @retval 
 */
void spi_rx_Data_Callback(uint8_t *rx_data)
{    
    uint8_t tmp_buf[SPI_TX_BUF_SIZE];
    if(rx_data !=NULL)
    {         
        if (rx_data[1] == 0xFF) 
        {
            //Dummy send to clear buffer.
        } 
        else if (rx_data[1] == BLE_SOF_CMD) 
        {        
            switch (rx_data[2]) {
                case BLE_INIT_CMD:
                        if(init_success ==false)
                        {
                            memcpy(tmp_buf, &rx_data[4], rx_data[3]);                                   
                            ble_init(tmp_buf,rx_data[3]);
                            toggle_led();
                        }
                        
                    break;
                    
                case BLE_START_ADV_CMD:
                        // TODO: As of now Advertising is done from the ble_init
                    break;
                
                case BLE_SEND_DATA_CMD:
                    memcpy(tmp_buf, &rx_data[4], rx_data[3]);
                    ble_send_data(tmp_buf,rx_data[3]);
                    break;
                    
                case BLE_START_OF_FILE:
                    memcpy(tmp_buf, &rx_data[4], rx_data[3]);                
                    ble_send_data(tmp_buf, rx_data[3]);
                    break;
                    
                case BLE_END_OF_FILE:
                    memcpy(tmp_buf, &rx_data[4], rx_data[3]);
                    ble_send_data(tmp_buf, rx_data[3]);
                    break;
 
                case BLE_RESET_CMD:
                    
                    /*Performing system reset*/   
                    NVIC_SystemReset();
                    break;
                    
                default :
                    break;
                    
            }
        } else {
            // Invalid Packet received, ignore as of now
        }
    }    
}
/******************************************************************************/
/* Global Functions                                                           */
/******************************************************************************/
/**
 * @brief  Data Handler Init, register for the BLE & SPI callbacks
 * @param  
 * @retval 
 */
void ble_data_handler_init(void)
{
    ble_data_rx_cb_register(ble_rx_Data_Callback);
    spi_data_rx_cb_register(spi_rx_Data_Callback);
}

/******************************************************************************/
/* END OF FILE                                                                */
/******************************************************************************/
