#include "mbed.h"
#include "mDot.h"
#include "MTSLog.h"
#include "LoRaInit.h"

static std::string config_network_name = "davedesk";
static std::string config_network_pass = "davedesk";
static uint8_t config_frequency_sub_band = 7;

void mDotRadioInit(mDot *dot)
{
    int32_t ret;

    // print library version information
    logInfo("version: %s", dot->getId().c_str());
    logInfo("Program is: mDot_LoRa_pump_control");

    dot->resetConfig();

    // set the logging level
    dot->setLogLevel(mts::MTSLog::ERROR_LEVEL);

    logInfo("setting frequency sub band");
    if ((ret = dot->setFrequencySubBand(config_frequency_sub_band)) != mDot::MDOT_OK) {
        logError("failed to set frequency sub band %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }

    logInfo("setting network name");
    if ((ret = dot->setNetworkName(config_network_name)) != mDot::MDOT_OK) {
        logError("failed to set network name %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }

    logInfo("setting network password");
    if ((ret = dot->setNetworkPassphrase(config_network_pass)) != mDot::MDOT_OK) {
        logError("failed to set network password %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }

    logInfo("setting TX spreading factor");
    if ((ret = dot->setTxDataRate(mDot::SF_7)) != mDot::MDOT_OK) {
        logError("failed to set TX datarate %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }

    logInfo("setting TX Output power");
    if ((ret = dot->setTxPower(18)) != mDot::MDOT_OK) {
        logError("failed to set TX outputpower %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }

    logInfo("setting RX Delay");
    if ((ret = dot->setRxDelay(1)) != mDot::MDOT_OK) {
        logError("failed to set TX outputpower %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }

    // request receive confirmation of packets from the gateway
    logInfo("enabling ACKs");
    if ((ret = dot->setAck(1)) != mDot::MDOT_OK) {
        logError("failed to enable ACKs %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }

    // save this configuration to the mDot's NVM
    logInfo("saving config");
    if (! dot->saveConfig()) {
        logError("failed to save configuration");
    }

//    logInfo("joining network");
//    while ((ret = dot->joinNetwork()) != mDot::MDOT_OK) {
//        logError("failed to join network %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    // in the 868 (EU) frequency band, we need to wait until another channel is available before transmitting again
//        osDelay(std::max((uint32_t)1000, (uint32_t)dot->getNextTxMs()));
//    }
//    logInfo("Joined Network");
}