#ifndef CONTROL_H
#define CONTROL_H

#include "global.h"
#include <string>
#include "OutputTask.h"


/*****************************************************************************
 * Control class
 * Contains the most pertinent control information to stack onto the output
 * entry
 ****************************************************************************/
class Control
{
private:
    std::string     id;             // control identifier
    Control_t       controlType;    // control type 
    std::string     input;          // input
    unsigned int    priority;       // control priority 
    ControlState    state;          // state (ON or OFF) 

public:
    // ctor
    Control(std::string id, Control_t controlType, std::string input, unsigned int priority, ControlState state) :
        id(id),  controlType(controlType), input(input), priority(priority), state(state) {}
    // dtor
    ~Control() { printf("\r%s invoked\n", __func__); }
    
    // displays a control's pertinents
    void display() {
        printf("[%-24s | %3s | %u] -> ",
               id.c_str(), (state == CONTROL_ON) ? "ON" : "OFF", priority);
    }

    std::string getId() const {
        return id;
    }
    
    Control_t getControlType(void) const { 
        return controlType;
    }
    
    std::string getInput(void) const {
        return input;
    }

    unsigned int getPriority() const {
        return priority;
    }

    ControlState getState(void) const {
        return state;
    }
    
    int getMappedState(void) const;

    void setState(ControlState _state) {
        state = _state;
    }
};

#endif 