/******************************************************************************
 * 
 * File:                ModbusMaster.h
 * Desciption:          interface for the ICE Modbus Master
 *
 *****************************************************************************/
#ifndef MODBUS_MASTER_H
#define MODBUS_MASTER_H

void ModbusMaster(void const *args);

#define SIZE_MB_BUFFER 50
#define MB_BAUD_RATE 19200

typedef union mr_register_32_bit_float
{
    float f;
    struct
    {
        uint16_t    lo;
        uint16_t    hi;
    }w;
    struct
    {
        uint8_t    lo_lo;
        uint8_t    lo_hi;
        uint8_t    hi_lo;
        uint8_t    hi_hi;
    }b;
} MR_REGISTER_32_BIT_FLOAT;

typedef union mr_register_32_bit_int
{
    int32_t i;
    struct
    {
        uint16_t    lo;
        uint16_t    hi;
    }w;
    struct
    {
        uint8_t    lo_lo;
        uint8_t    lo_hi;
        uint8_t    hi_lo;
        uint8_t    hi_hi;
    }b;
} MR_REGISTER_32BIT_INT;

typedef union mr_register_32_bit_uint
{
    uint32_t i;
    struct
    {
        uint16_t    lo;
        uint16_t    hi;
    }w;
    struct
    {
        uint8_t    lo_lo;
        uint8_t    lo_hi;
        uint8_t    hi_lo;
        uint8_t    hi_hi;
    }b;
} MR_REGISTER_32BIT_UINT;

typedef union mr_register_16_bit_int
{
    int16_t w;
    struct
    {
        uint8_t    lo;
        uint8_t    hi;
    }b;
} MR_REGISTER_16BIT_INT;

typedef union mr_register_16_bit_uint
{
    uint16_t w;
    struct
    {
        uint8_t    lo;
        uint8_t    hi;
    }b;
} MR_REGISTER_16BIT_UINT;

#define TYPE_32BIT_FLOAT    0
#define TYPE_32BIT_INT      1
#define TYPE_32BIT_UINT     2
#define TYPE_16BIT_INT      3
#define TYPE_16BIT_UINT     4
#define TYPE_MULTI_BYTE     5

//Frame crc calucation
uint16_t modbus_crc(uint8_t* buf, int len);
void modbus_recv();
void SendModbusCommand(uint8_t slave_address, uint16_t firstReg, uint16_t noRegs);
void modbus_init( uint16_t baudRate );
bool mbIntComplete();

bool ReadModbus_32bit_float( float *float_value, int order, unsigned char *rd_buf );
bool ReadModbus_32bit_int( int32_t *int32_value, int order, unsigned char *rd_buf );

bool WriteModbus_32bit_float( float float_value, int order, unsigned char *xmt_buf );
bool WriteModbus_32bit_int( int32_t int32_value, int order, unsigned char *xmt_buf );

#endif
