#ifndef _EEP_H_
#define _EEP_H_

// -------------------------------------------------------------------------------------------------
// globals

#define EEP_NDEV 2       // number of devices
#define EEP_NBYT 0x40000 // maximum bytes per device (262144)

#define EE0_ADDR 0xA0 // control byte: 0b1010(A2)(A17)(A16)(R/W) -> U7 AT24CM02 (A2=0)
#define EE1_ADDR 0xA8 // control byte: 0b1010(A2)(A17)(A16)(R/W) -> U8 AT24CM02 (A2=1)

extern int eep_verbose;

// -------------------------------------------------------------------------------------------------
// function prototypes

unsigned char eep_get_byte(int dev, unsigned long addr);
void          eep_set_byte(int dev, unsigned long addr, unsigned char wbyte);

// -------------------------------------------------------------------------------------------------

#endif // _EEP_H_
