#include "LogLocalApi.h"
#include "MTSLog.h"
#include "global.h"
#include "eep.h"

#define WAIT_TIME 5

void LogLocalApi( const char *logString )
{
    LogLocalApi_PushEntry( logString );
}

void LogLocalApi_PushEntry( const char *logString )
{
    unsigned long addr;
    unsigned long waddr;
    int dev;
    int i;

    logInfo("%s\r\n", logString );

    // last 3 bytes of device 1 store next write address.
    unsigned char data0 = eep_get_byte(1, EEP_NBYT-3);
    unsigned char data1 = eep_get_byte(1, EEP_NBYT-2);
    unsigned char data2 = eep_get_byte(1, EEP_NBYT-1);


//    printf("read data0=0x%x, data1=0x%x, data2=0x%x\r\n", data0, data1, data2);


    addr = ((data0<<16) & 0x03);
    addr |= (data1<<8);
    addr |= (data2);
    dev = ((data0<<16) & 0x04);

//    printf("start: device=%d, addr=0x%x\r\n", dev, addr);

    int len=strlen(logString);
    if( len >=LOG_BYTES_PER_ENTRY ) {
        logError("String too large, max=%d, len=%d", LOG_BYTES_PER_ENTRY, len );
        return;
    }
    for( i=0,waddr=addr; i<=len; waddr++,i++ ) {
        eep_set_byte(dev, waddr, logString[i]);
        Thread::wait(WAIT_TIME);
//        logInfo("dev=%d, waddr=0x%x, wbyte=0x%x\r\n", dev, waddr, logString[i] );
    }
    waddr = addr + LOG_BYTES_PER_ENTRY;

//    printf("final: device=%d, addr=0x%x, strlen=%d\r\n", dev, waddr, len);

    if( (waddr+127) >= EEP_NBYT ) {
        if( dev == 0 )
            data0 = ((waddr&0x00030000)>>16)|0x4;
        else
            data0 = ((waddr&0x00030000)>>16);
    }
    data1 = (waddr&0x0000FF00)>>8;
    data2 = (waddr&0x000000FF);

//    printf("storing new address: data0=0x%x, data1=0x%x, data2=0x%x\r\n", data0, data1, data2);

    eep_verbose = 0;
    eep_set_byte(1, EEP_NBYT-3, data0);
    Thread::wait(WAIT_TIME);
    eep_set_byte(1, EEP_NBYT-2, data1);
    Thread::wait(WAIT_TIME);
    eep_set_byte(1, EEP_NBYT-1, data2);
    Thread::wait(WAIT_TIME);
    eep_verbose = 0;
}

bool LogLocalApi_PopEntry( char *logString )
{
    unsigned long addr;
    long raddr;
    int dev;
    int i;
    
    memset( logString, '\0', LOG_BYTES_PER_ENTRY );

    // last 3 bytes of device 1 store next write address.
    unsigned char data0 = eep_get_byte(1, EEP_NBYT-3);
    unsigned char data1 = eep_get_byte(1, EEP_NBYT-2);
    unsigned char data2 = eep_get_byte(1, EEP_NBYT-1);

//    printf("read data0=0x%x, data1=0x%x, data2=0x%x\r\n", data0, data1, data2);

    addr = ((data0<<16) & 0x03);
    addr |= (data1<<8);
    addr |= (data2);
    dev = ((data0<<16) & 0x04);

    raddr = addr - LOG_BYTES_PER_ENTRY;
    if( raddr < 0 ) {
        if( dev == 1 ) {
            dev = 0;
            raddr = LOG_END_OF_STORAGE - LOG_BYTES_PER_ENTRY;
        } else {
//            printf("already at first entry\r\n");
            return false;
        }
    }

//    printf("start: device=%d, addr=0x%x, raddr=0x%x\r\n", dev, addr, raddr);

    for( i=0,raddr; i<=LOG_BYTES_PER_ENTRY; raddr++,i++ ) {
        logString[i] = eep_get_byte(dev, raddr);
        Thread::wait(WAIT_TIME);
//        logInfo("dev=%d, waddr=0x%x, wbyte=0x%x\r\n", dev, waddr, logString[i] );
    }
    logString[LOG_BYTES_PER_ENTRY-1] = '\0';
    raddr = addr - LOG_BYTES_PER_ENTRY;

//    printf("final: raddr=0x%x, strlen=%d\r\n", raddr, strlen(logString));

    if( dev == 0 )
        data0 = ((raddr&0x00030000)>>16);
    else
        data0 = ((raddr&0x00030000)>>16)|0x4;
    data1 = (raddr&0x0000FF00)>>8;
    data2 = (raddr&0x000000FF);

//    printf("storing new address: data0=0x%x, data1=0x%x, data2=0x%x\r\n", data0, data1, data2);

    eep_verbose = 0;
    eep_set_byte(1, EEP_NBYT-3, data0);
    Thread::wait(WAIT_TIME);
    eep_set_byte(1, EEP_NBYT-2, data1);
    Thread::wait(WAIT_TIME);
    eep_set_byte(1, EEP_NBYT-1, data2);
    Thread::wait(WAIT_TIME);
    eep_verbose = 0;
    
    return true;
}