/******************************************************************************
 *
 * File:                TimerControl.h
 * Desciption:          ICE Timer Control Class
 *
 *****************************************************************************/
#ifndef TIMERCONTROL_H
#define TIMERCONTROL_H

#include <string>
#include <stdio.h>
#include <vector>

typedef enum {
    TIMER_CONTROL_OK,
    TIMER_CONTROL_ERROR,
    TIMER_CONTROL_DESTROY
} TimerError_t;

class TimerControl
{
private:
    std::string     controlFile;
    std::string     id;
    std::string     output;
    unsigned int    priority;
    unsigned long   startTime;
    unsigned int    duration;
    unsigned long   actualStartTime;

    enum State {
        STATE_OFF,
        STATE_RUNNING,
        STATE_DISABLED
    };
    State           currentState;

    // start the timer
    bool timerStart(void);

    // stop the timer
    bool timerStop(void);

    // start a feed
    void startFeed(void);

    // stop a feed
    void stopFeed(void);

public:
    TimerControl() {};
    ~TimerControl() {
        printf("\r%s destructor invoked\n", __func__);
    }
    // load a control from the control file
    bool load(std::string filename);

    // start the timer control
    void start(void);

    // update the timer control (state machine)
    TimerError_t update(void);

    // unregister the control with the output task
    void unregisterControl(void);

    // display the timer control
    void display(void);

    std::string getControlFile(void) const {
        return controlFile;
    }

    std::string getId(void) const {
        return id;
    }

    std::string getOutput(void) const {
        return output;
    }

    unsigned int getPriority(void) const {
        return priority;
    }

    unsigned long getStartTime(void) const {
        return startTime;
    }

    unsigned int getDuration(void) const {
        return duration;
    }

    State getCurrentState(void) const {
        return currentState;
    }
};

#endif
