/******************************************************************************
 *
 * File:                SetpointControl.h
 * Desciption:          ICE Timer Control Class
 *
 *****************************************************************************/
#ifndef SETPOINTCONTROL_H
#define SETPOINTCONTROL_H

#include <string>

using namespace std;

class SetpointControl
{
private:
    string          controlFile;        // name of the control file
    string          id;                 // control identifier
    int             priority;           // control priority
    string          input;              // control input
    string          output;             // control output
    double          setpoint;           // setpoint value
    double          productFactor;
    bool            actingDir;          // acting direction, 1 direct - pH, 0 indirect - inhibitor
    double          highAlert;
    double          lowAlert;
    double          highFailsafe;
    double          lowFailsafe;
    double          tolerance;          // the error margining 
    enum State {
        STATE_INIT,
        STATE_STARTUP,
        STATE_CONTROL_OFF,
        STATE_CONTROL_ON,
        STATE_DISABLE,
        STATE_RELOAD,
        STATE_MAX
    };
    State           currentState;

public:
    // ctor
    SetpointControl() { currentState = STATE_INIT; };
    // dtor
    ~SetpointControl() {
        printf("\r%s destructor invoked\n", __func__);
        // TODO: unregister the control with the output task
    }

    // load the control data
    bool load(string filename);

    // unregister the control with the output task
    void unregisterControl(void);

    // start the control
    void start(void);

    // update the control
    void update(void);

    bool underLimit();
    bool overLimit();

    // state transition functions
    void startFeed(void);
    void stopFeed(void);
    
    void display(void);

    string getControlFile(void) const {
        return controlFile;
    }
    string getId(void) const {
        return id;
    }
    unsigned int getPriority(void) const {
        return priority;
    }
    string getInput(void) const {
        return input;
    }
    string getOutput(void) const {
        return output;
    }
    float getProductFactor(void) const {
        return productFactor;
    }
    int getActingDir(void) const {
        return actingDir;
    }
    float getSetpoint(void) const {
        return setpoint;
    }
    float getHighAlert(void) const {
        return highAlert;
    }
    float getLowAlert(void) const {
        return lowAlert;
    }
    float getHighFailsafe(void) const {
        return highFailsafe;
    }
    float getLowFailsafe(void) const {
        return lowFailsafe;
    }
    
    State getCurrentState(void) const {
        return currentState;
    }
};

#endif