/******************************************************************************
 *
 * File:                ManualControl.h
 * Desciption:          ICE Manual Control Class
 *
 *****************************************************************************/
#ifndef MANUALCONTROL_H
#define MANUALCONTROL_H

#include <string>

using namespace std;

class ManualControl
{
private:
    string          controlFile;        // name of the control file
    string          id;                 // identifier
    string          output;             // output
    unsigned int    type;               // timed, continuous, setpoint
    unsigned int    priority;           // control priority
    unsigned int    duration;           // in seconds (not implemented)
    float           setpoint;           // setpoint (not implemented)
    unsigned int    state;              // ON or OFF
    unsigned int    percent;            // analog/manual value

    enum State {
        STATE_INIT,                     // init
        STATE_STARTUP,                  // control has been started
        STATE_CONTROL_ON,               // control is ON
        STATE_CONTROL_OFF               // control is OFF
    };
    State           currentState;

    // power an output
    int powerOutput(void);

public:
    // ctor
    ManualControl() {};
    // dtor
    ~ManualControl() {
        printf("\r%s destructor invoked\n", __func__);
    }
    // load a control from the control file
    bool load(string filename);

    // start a control
    void start(void);

    // update a control (this is called periodically)
    int update(void);

    // unregister a control
    int unregisterControl(void);

    // display the control
    void display(void);

    string getControlFile(void) const {
        return controlFile;
    }

    string getId(void) const {
        return id;
    }

    string getOutput(void) const {
        return output;
    }

    unsigned int getType(void) const {
        return type;
    }

    unsigned int getPriority(void) const {
        return priority;
    }

    unsigned int getDuration(void) const {
        return duration;
    }

    float getSetpoint(void) const {
        return setpoint;
    }

    unsigned int getState(void) const {
        return state;
    }

    unsigned int getPercent(void) const {
        return percent;
    }
};

#endif
