/******************************************************************************
 *
 * File:                CompositeControl.h
 * Desciption:          ICE Composite Control Class
 *
 *****************************************************************************/
#ifndef COMPOSITECONTROL_H
#define COMPOSITECONTROL_H

#include <string>
#include <vector>
#include <stdio.h>
#include "global.h"
#include "CompositeAlgorithm.h"

class CompositeControl
{
private:
    typedef struct oe_tag {
        std::string     tag;
        std::string     response;
    } OutputElement;

    std::string                 controlFile;    // the control file
    std::string                 id;             // composite identifier
    std::string                 tag;            // i/o tag to evaluate
    unsigned int                priority;       // control priority
    std::string                 ca;             // control algorithm
    std::vector<OutputElement>  outputs;        // (virtual) output(s)

    enum State {
        STATE_INIT,
        STATE_START,
        STATE_CONTROL_OFF,
        STATE_CONTROL_ON,
        STATE_MAX
    };
    State                       currentState;   // current state

    std::string executeCommand(void);
    std::string executeOperation(const CompositeAlgorithm*);
    void triggerOutputs(std::string result);
    void sendMail(std::string io_tag, OutputAction action);

public:
    CompositeControl() { }
    ~CompositeControl() {
        printf("\r%s invoked\n", __func__);
    }

    bool load(std::string controlFile);

    void start(void);

    void update(void);

    void unregisterControls();

    std::string getControlFile(void) const {
        return controlFile;
    }
    std::string getId(void) const {
        return id;
    }

    State getState(void) const {
        return currentState;
    }

    std::string getTag(void) const {
        return tag;
    }
    std::vector<std::string> getOutputs(void) const;

    void display(void);
};

#endif
