/******************************************************************************
 * 
 * File:                ConfigurationHandler.h
 * Desciption:          interface file for the ICE Configuration Handler
 *
 *****************************************************************************/
#ifndef CONFIGURATION_HANDLER_H
#define CONFIGURATION_HANDLER_H

#include "SetpointControl.h"
#include "TimerControl.h"
#include "ManualControl.h"
#include "CompositeControl.h"
#include "FailsafeControl.h"
#include "CompositeAlgorithm.h"
#include <map>

typedef struct va_tag {
    std::string     tag;
    std::string     opr;
    std::string     op;
} VirtualAlgorithm;
    

void ConfigurationHandler(void const *args);

// APIs
void ConfigurationHandler_showControls(void);
void ConfigurationHandler_showAlgorithms(void);

// map["control_sp_1.json"] : setpointControl
typedef map<string, SetpointControl*> StringSetpointMap;

// map["o_rly1"] : vector<TimerControl>.first
//                 vector<TimerControl>.second
// map["o_rly2"] : vector<TimerControl>.first
typedef map<string, vector<TimerControl*> > StringVectorTimerMap;

//map["control_mn_1.json"] : manualControl
typedef map<string, ManualControl*> StringManualMap;

// map["control_cmp_1.json"] : compositeControl
typedef map<string, CompositeControl*> StringCompositeMap;

// map["control_fs_rly1.json"] : failsafeControl
typedef map<string, FailsafeControl*> StringFailsafeMap;

// map["EQUAL_TO_1"].<operands stucture>
typedef map<string, CompositeAlgorithm *> StringAlgorithmMap;
 
extern StringSetpointMap        setpointTable;
extern StringVectorTimerMap     timerTable;
extern StringManualMap          manualTable;
extern StringCompositeMap       compositeTable;
extern StringAlgorithmMap       algorithmTable;
extern StringFailsafeMap        failsafeTable;

#endif
