#ifndef COMPOSITEALGORITHM_H
#define COMPOSITEALGORITHM_H

#include <stdio.h>
#include <string>

class CompositeAlgorithm
{
private:
    std::string     controlFile;        // the control file
    std::string     id;                 // algorithm id
    std::string     tag;                // input (real or virtual)
    std::string     opr;                // right operand
    std::string     op;
    std::string     resultTrue;
    std::string     resultFalse;
public:
    CompositeAlgorithm() {}
    ~CompositeAlgorithm() {
        printf("%s invoked", __func__);
    }

    bool load(const std::string);

    void display(void);

    std::string getId(void) const {
        return id;
    }
    std::string getTag(void) const { 
    return tag;
    }
    std::string getOpr(void) const { return opr; }
    std::string getOp(void) const { return op; }
    std::string getResultTrue(void) const { return resultTrue; }
    std::string getResultFalse(void) const { return resultFalse; }
};

#endif

