#include "global.h"
#include "cJSON.h"
#include "CompositeAlgorithm.h"

bool CompositeAlgorithm::load(const std::string _controlFile)
{
    controlFile = _controlFile;

    // open and read from the control file
    mDot::mdot_file file = GLOBAL_mdot->openUserFile(controlFile.c_str(), mDot::FM_RDONLY);
    if ( file.fd < 0 ) {
        logError("%s: failed to open %s\n", __func__, controlFile.c_str());
        return false;
    }

    // read the data into a buffer
    char dataBuf[MAX_FILE_SIZE];

    int bytes_read = GLOBAL_mdot->readUserFile(file, (void *)dataBuf, sizeof(dataBuf));
    if ( bytes_read != sizeof(dataBuf) ) {
        logError("%s: failed to read %d bytes from %s", __func__, sizeof(dataBuf), controlFile.c_str());
        // caller should destroy the object
        return false;
    }

    // close the file
    GLOBAL_mdot->closeUserFile(file);

    // parse the JSON data
    cJSON * root = cJSON_Parse(dataBuf);
    
    id              = cJSON_GetObjectItem(root,"id")->valuestring;
    opr             = cJSON_GetObjectItem(root, "opr")->valuestring;
    op              = cJSON_GetObjectItem(root, "op")->valuestring;
    resultTrue      = cJSON_GetObjectItem(root, "true")->valuestring;
    resultFalse     = cJSON_GetObjectItem(root, "false")->valuestring;
    
    cJSON_Delete(root);

    return true;
}

void CompositeAlgorithm::display(void)
{
    printf("\r          id : %s\n", id.c_str());
    printf("\r         opr : %s\n", opr.c_str());
    printf("\r          op : %s\n", op.c_str());
    printf("\r        true : %s\n", resultTrue.c_str());
    printf("\r       false : %s\n", resultFalse.c_str());
    printf("\r\n");
}