#include "LoggerApi.h"
#include "LogHandler.h"
#include "CloudDataHandler.h"
#include "MTSLog.h"
#include "global.h"
#include <sstream>
#include <iostream>

void EventLoggerApi( EventReasonStruct_t &eventReason )
{
    time_t curr_sec = time(0);

    LoggerQueue_t *LoggerEvent = LoggerQueue.alloc();
    memset( LoggerEvent->log_entry, 0, sizeof(LoggerEvent->log_entry) );

//   std::ostringstream log_event;
//   log_event << "tag:"<< iter->first.c_str() << " value:" << float_value;

    snprintf( LoggerEvent->log_entry, sizeof(LoggerEvent->log_entry),
              "{""\"mtype\":\"%d\",""\"t\":\"%ld\",""\"e\":\"%d\",""\"i\":\"%s\",""\"iv\":\"%2.2f\",""\"o\":\"%s\",""\"ov\":\"%2.2f\"}",
              EVENT_LOG_MTYPE, curr_sec, eventReason.eventReason, eventReason.inputTag, eventReason.inputValue,
              eventReason.outputTag, eventReason.outputValue );
    LoggerEvent->position = 0;
    LoggerQueue.put(LoggerEvent);

    logInfo("len=%d: %s", strlen(LoggerEvent->log_entry), LoggerEvent->log_entry );

    PeriodicLogger( true );
}

void LiveData2Message( const char *liveData, char *messageString, int len )
{
    time_t curr_sec = time(0);
    memset( messageString, 0, len );
    snprintf( messageString, len, "{""\"mtype\":\"%d\",""\"t\":\"%ld\",%s}", LIVE_DATA_MTYPE, curr_sec, liveData );
    logInfo("%s:%d: packetLen=%d: %s", __func__,__LINE__,strlen(messageString), messageString );
}

void LiveDataLoggerApi( const char *liveData )
{
    time_t curr_sec = time(0);

    LoggerQueue_t *LoggerEvent = LoggerQueue.alloc();

    LiveData2Message( liveData, LoggerEvent->log_entry, sizeof(LoggerEvent->log_entry) );

    LoggerEvent->position = 0;
    LoggerQueue.put(LoggerEvent);

    logInfo("dataLen=%d, packetLen=%d: %s", strlen(liveData), strlen(LoggerEvent->log_entry), LoggerEvent->log_entry );
}

void PeriodicLogger( bool force )
{
    bool log_sent=false;
    std::ostringstream log_event;

    int map_count = ModbusRegisterMap.size();
    int collected_count = 0;

    log_event << "\"lr\":[";
    std::map<std::string, ModbusRegister>::iterator iter;
    for (iter = ModbusRegisterMap.begin(); iter != ModbusRegisterMap.end(); ++iter) {

        collected_count = collected_count + 1;

        log_event << "{\"t\":"<< "\"" << iter->first.c_str() << "\"," << "\"v\":"<< "\"" << iter->second.float_value<< "\"},";
        log_sent = false;
        if( log_event.str().size() >= 150 ) {
            std::string str = log_event.str();
            str.erase( str.size() - 1 );
            if( collected_count == map_count ) {
                str.append("],\"seq\":\"0\"");
            } else {
                str.append("],\"seq\":\"1\"");
            }
//            printf("%s:%d: Logging %s : len=%d\r\n", __func__, __LINE__, str.c_str(), str.length() );
            LiveDataLoggerApi( str.c_str() );
            log_event.str("");
            log_event.clear();
            log_event << "\"lr\":[";
            log_sent = true;
        }
    }
    if( log_sent == false ) {
        std::string str = log_event.str();
        str.erase( str.size() - 1 );
        str.append("],\"seq\":\"0\"");
        if( str.length() > 20 ) {
//            printf("%s:%d: Logging %s : len=%d\r\n", __func__, __LINE__, str.c_str(), str.length() );
            LiveDataLoggerApi( str.c_str() );
        }
    }
}

void GetCurrentReadings( char *currentReadings, int len )
{
    bool log_sent=false;
    std::ostringstream log_event;

    log_event << "\"lr\":[";
    std::map<std::string, ModbusRegister>::iterator iter;
    for (iter = ModbusRegisterMap.begin(); iter != ModbusRegisterMap.end(); ++iter) {
        log_event << "{\"t\":"<< "\"" << iter->first.c_str() << "\"," << "\"v\":"<< "\"" << iter->second.float_value<< "\"},";
    }

    std::string str = log_event.str();
    str.erase( str.size() - 1 );
    str.append("],\"seq\":\"0\"");
    LiveData2Message( str.c_str(), currentReadings, len );
//    printf("GetCurrentReadings: packetLen=%d: %s, str.size(%d), (%s)\r\n", strlen(currentReadings), currentReadings, str.size(), str.c_str() );
}

void GetTagReadings( std::vector<std::string>  RequestedTags, char *currentReadings, int len )
{
    std::ostringstream log_event;

    log_event << "\"lr\":[";
    std::vector<std::string>::iterator iter;
    for (iter = RequestedTags.begin(); iter != RequestedTags.end(); ++iter) {
        log_event << "{\"t\":"<< "\"" << iter->c_str() << "\"," << "\"v\":"<< "\"" << ModbusRegisterMap[*iter].float_value<< "\"},";
    }

    std::string str = log_event.str();
    str.erase( str.size() - 1 );
    str.append("]");
    LiveData2Message( str.c_str(), currentReadings, len );
//    printf("GetCurrentReadings: packetLen=%d: %s, str.size(%d), (%s)\r\n", strlen(currentReadings), currentReadings, str.size(), str.c_str() );
}