/******************************************************************************
 *
 * File:                BLEDataHandler.cpp
 * Desciption:          source for the ICE Bluetooth Low Energy Data Handler
 *
 *****************************************************************************/
#include "global.h"
#include <stdio.h>
#include "BLEDataHandler.h"
#include "CloudDataHandler.h"
#include "LoggerApi.h"
#include "ble_main.h"
#include "ble_init.h"
#include "ble_msg_handler.h"
#include "ble_spi.h"
#include "cJSON.h"

/*****************************************************************************
 * Function:             BLEDataHandler
 * Description:          entry point for the Analytics Logger
 *
 * @param                (IN) args (user-defined arguments)
 * @return               none
 *****************************************************************************/

BLE_FILE BLE;
BLE_INIT ble_init;

#define BLE_DEVICE_NAME "Ecolab"
#define BLE_RECEIVE_BUFFER_SIZE 500
#define BLE_TRANSMIT_BUFFER_SIZE 500

bool BLE_StringReceived = false;
char BLE_ReceiveString[BLE_RECEIVE_BUFFER_SIZE];

/*****************************************************************************
* Function:            BLE data receive callback
* Description:         Process BLE data
*
* @param               spi_rcv_array
* @param               *rx_data
* @param               length
* @return              none
*****************************************************************************/
char * fake_string = "{  \"mtype\":1200, \"getreadings\":[ { \"tag\":\"i_tra01\" } ] }"; // use this to fake a message out requesting i_tra01 readings
//char * fake_string = "{  \"mtype\":1000, \"mbcommand\":{ \"id\":\"READ_TRASAR\"," "\"node\":\"1\"," "\"func\":\"4\"," "\"sreg\":\"9\"," "\"nreg\":\"2\"," "\"dtype\":\"0\"," "\"order\":\"2\"," "\"value\":\"0\" } }"; // use this to fake a message out requesting i_tra01 readings
static void BleRxDataCallback(uint8_t *rx_data, uint8_t len)
{
#if 0  //commented for Demo testing
    memset( BLE_ReceiveString, 0, BLE_RECEIVE_BUFFER_SIZE );
    if( len >= BLE_RECEIVE_BUFFER_SIZE ) {
        printf("Received file larger than buffer (len=%d)\r\n", len );
        return;
    }

//    memcpy( BLE_ReceiveString, rx_data, len ); // comment out and use line below until we receive JSON from APP
    // temporary until we receive actual string from APP
    memcpy( BLE_ReceiveString, fake_string, strlen(fake_string) );
    BLE_StringReceived = true;
//    printf("Data Received:  %s\r\n", BLE_ReceiveString);
#endif 

    printf("Data Received:  ");
    for(int i=0;i<len;i++)
    {
        printf("%c",rx_data[i]);
        
        if(rx_data[0] == 0x61)
        {
            BLE_StringReceived =true;
        }        
    }
    printf("\n\r");
}

void BLEDataHandler(void const *args)
{
    uint8_t tx_array[500];
    uint8_t event_status;

    /*TODO
        Getting the init status from Nano BLE register and
        Proceed based on the status.
    */
    event_status = BLE.ConfigureBLEDevice(BLE_DEVICE_NAME);
    BleDataRxCbRegister(BleRxDataCallback);
    while(1) {

        event_status = PollBLEEvents();
        if(event_status == true && BLE_StringReceived == true) {
            GetCurrentReadings( (char *)tx_array, sizeof(tx_array));
            BLE.SendFile(tx_array,strlen((char *)tx_array));
            BLE_StringReceived = false;
        }
        Thread::wait(100);
    }
}
#if 0
void BLEDataHandler(void const *args)
{
    uint8_t tx_array[BLE_TRANSMIT_BUFFER_SIZE];
    uint8_t event_status;

    /*TODO
        Getting the init status from Nano BLE register and
        Proceed based on the status.
    */
    event_status = BLE.ConfigureBLEDevice(BLE_DEVICE_NAME);
    BleDataRxCbRegister(BleRxDataCallback);
    while(1) {

        event_status = PollBLEEvents();
        if(event_status == true && BLE_StringReceived == true) {

            cJSON * root = cJSON_Parse( BLE_ReceiveString );
            int mType = cJSON_GetObjectItem(root,"mtype")->valueint;

            printf("mType=%d, str=%s\r\n",mType, BLE_ReceiveString);
            switch( mType ) {
                case BT_GETLIVE_COMMAND_MTYPE: {

                    std::vector<std::string>  RequestedTags;
                    cJSON *getreadings    = cJSON_GetObjectItem(root, "getreadings");
                    for ( int i = 0; i < cJSON_GetArraySize(getreadings); ++i ) {
                        cJSON *item = cJSON_GetArrayItem(getreadings, i);
                        std::string tag      = cJSON_GetObjectItem(item, "tag")->valuestring;
                        RequestedTags.push_back(tag);
                    }
                    GetTagReadings( RequestedTags, (char *)tx_array, sizeof(tx_array) );
                    printf("%s:%d: Sending Reply to APP: %s\r\n",__func__,__LINE__,tx_array);
                    BLE.SendFile(tx_array,strlen((char *)tx_array));
                    break;
                }
                case BT_MODBUS_COMMAND_MTYPE: {
                    printf("%s:%d: GOT MODBUS COMMAND\r\n",__func__,__LINE__);

                    cJSON *mbcommand    = cJSON_GetObjectItem(root, "mbcommand");
                    std::string payload_string = cJSON_PrintUnformatted(mbcommand);

                    printf("%s:%d: Sending Command Request to ModbusMaster: %s\r\n",__func__,__LINE__,payload_string.c_str());
                    
                    ModbusMasterReq_t *mail = ModbusMasterMailBox.alloc();
                    mail->action = ACTION_EXEC_CMD;
                    mail->replyThread = BLE_HANDLER;
                    strncpy( mail->controlFile, payload_string.c_str(), (sizeof(mail->controlFile)-1));
                    ModbusMasterMailBox.put(mail);
                    break;
                }
                default:
                    printf("unknown mtype received\r\n");
                    break;
            }
            BLE_StringReceived = false;
            cJSON_Delete(root);
        }

        // This will wait 100ms for a message
        osEvent evt = BLEHandlerMailBox.get(100);
        if (evt.status == osEventMail) {
            BLEHandlerReq_t *mail = (BLEHandlerReq_t*)evt.value.p;
            printf("%s:%d: Sending Reply to APP: %s\r\n",__func__,__LINE__,mail->reply);
            BLE.SendFile((uint8_t *)mail->reply,strlen((char *)mail->reply));
            BLEHandlerMailBox.free(mail);
        }
    }
}

#endif