/******************************************************************************
 *
 * File:                AnalyticsLogger.cpp
 * Desciption:          source for the ICE Analytics Logger
 *
 *****************************************************************************/
#include "global.h"
#include <stdio.h>
#include <string>
#include <sstream>
#include <iostream>
#include "AnalyticsLogger.h"
#include "LoggerApi.h"
#include "eep.h"
#include "rtc.h"

/*****************************************************************************
 * Function:             AnalyticsLogger
 * Description:          entry point for the Analytics Logger
 *
 * @param                (IN) args (user-defined arguments)
 * @return               none
 *****************************************************************************/
void AnalyticsLogger(void const *args)
{
    struct tm       *ts;
    time_t curr_sec;
    int last_min=8;
    bool log_sent=false;

    while ( true ) {

        std::ostringstream log_event;

        curr_sec = time(0);
        ts = localtime(&curr_sec);
//        printf("curr_sec=%ld, min=%d (last=%d)\r\n", curr_sec, ts->tm_min, last_min );
        if( ((ts->tm_min%5) == 0) && (ts->tm_min != last_min) ) {
            last_min = ts->tm_min;

            int map_count = ModbusRegisterMap.size();
            int collected_count = 0;

            log_event << "\"lr\":[";
            std::map<std::string, ModbusRegister>::iterator iter;
            for (iter = ModbusRegisterMap.begin(); iter != ModbusRegisterMap.end(); ++iter) {
                
                collected_count = collected_count + 1;

                log_event << "{\"t\":"<< "\"" << iter->first.c_str() << "\"," << "\"v\":"<< "\"" << iter->second.float_value<< "\"},";
                log_sent = false;
                if( log_event.str().size() >= 150 ) {
                    std::string str = log_event.str();
                    str.erase( str.size() - 1 );
                    if( collected_count == map_count ) {
                        str.append("],\"seq\":\"0\"");
                    } else {
                        str.append("],\"seq\":\"1\"");
                    }
//                    printf("%s:%d: Logging %s : len=%d\r\n", __func__, __LINE__, str.c_str(), str.length() );
                    LiveDataLoggerApi( str.c_str() );
                    log_event.str("");
                    log_event.clear();
                    log_event << "\"lr\":[";
                    log_sent = true;
                }
            }
            if( log_sent == false ) {
                std::string str = log_event.str();
                str.erase( str.size() - 1 );
                str.append("],\"seq\":\"0\"");
                if( str.length() > 20 ) {
//                    printf("%s:%d: Logging %s : len=%d\r\n", __func__, __LINE__, str.c_str(), str.length() );
                    LiveDataLoggerApi( str.c_str() );
                }
            }
        }

        Thread::wait(5000);
    }
}