/**
  ******************************************************************************
  * @file    ble_uart.cpp
  * @author  Happiesstminds Firmware Team
  * @version v1.0
  * @date    4-Oct-2016
  * @brief   
  *
  ******************************************************************************
  * @attention
  *  
  *
  ******************************************************************************
  */

/******************************************************************************/
/* Include Files*/
/******************************************************************************/
#include "mbed.h"
#include "ble_msg_handler.h"
/******************************************************************************/
/* Local Defines                                                              */
/******************************************************************************/
uint8_t rx_buf[24];
SPI spimaster(SPI1_MOSI, SPI1_MISO, SPI1_SCK);
DigitalOut cs(SPI1_CS);

/******************************************************************************/
/* Global Functions                                                           */
/******************************************************************************/


/*****************************************************************************
 * Function:            InitSpiMaster()
 * Description:         InitSpiMaster 
 *
 * @param               None
 * @return              none
 *****************************************************************************/
uint8_t InitSpiMaster(void)
{
     uint8_t status = SUCCESS;
    // Chip must be deselected
    cs = 1;
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    spimaster.format(8, 0);
    // spimaster.frequency(1000000);
    spimaster.frequency(1000000);
    return status;
}

/*****************************************************************************
 * Function:            WriteSpiData()
 * Description:         WriteSpiData 
 *
 * @param               pointer to buffer
  * @param              length
 * @return              none
 *****************************************************************************/
uint8_t WriteSpiData(uint8_t * p_buffer, uint16_t length)
{    
    uint8_t i;
    uint8_t status = SUCCESS;
    int response;  //need to be removed
    // Select the device by seting chip select low    
    
    for(i=0;i<length;i++)
    {
        cs = 0;
        response = spimaster.write(p_buffer[i]);
        cs = 1;
        wait_ms(5);
    }    

    return status;      
}

/*****************************************************************************
 * Function:            PollBLEEvents()
 * Description:         Polls for BLE events
 * @param               pointer to rx_buf
 * @return              none
 *****************************************************************************/
 
uint8_t PollBLEEvents(void)
{
    uint8_t i =0;
    uint8_t msg_len;
    
    cs = 0;
    rx_buf[0] = spimaster.write(0xAA);
    cs = 1;
    wait_ms(5);
          
    if(rx_buf[0]==0x01)
    {        
        cs = 0;
        rx_buf[1] = spimaster.write(0xAA);
        cs = 1;
        wait_ms(5);
        cs = 0;
        rx_buf[2] = spimaster.write(0xAA);
        cs = 1;
        wait_ms(5);
        
        msg_len = rx_buf[2];
        for(i = 3; i < msg_len; i++)
        {
            cs = 0;
            rx_buf[i] = spimaster.write(0xFF);
            cs = 1;
            wait_ms(5);
        }
        
        ProcessBleRxEvents(rx_buf,rx_buf[2]);
    }    
    return  rx_buf[0];    
}
/******************************************************************************/
/* END OF FILE                                                                */
/******************************************************************************/