/**
  ******************************************************************************
  * @file    ble_uart.cpp
  * @author  Happiesstminds Firmware Team
  * @version v1.0
  * @date    4-Oct-2016
  * @brief   
  *
  ******************************************************************************
  * @attention
  *  
  *
  ******************************************************************************
  */

/******************************************************************************/
/* Include Files*/
/******************************************************************************/

#include "mbed.h"
#include "ble_msg_handler.h"
#include "ble_spi.h"
#include "ble_main.h"
/******************************************************************************/
/* Defines                                                                    */
/******************************************************************************/
#define MAX_FILE_SIZE 1000

volatile bool isDeviceConnected;
static ble_data_ready_callback_t data_ready_cb;
uint8_t json_array[MAX_FILE_SIZE];
uint16_t count,file_index,file_size;
  /*****************************************************************************
 * Function:            BLE data receive callback
 * Description:         Function used to register ble data receive callback 
 *
 * @param               ble_data_ready_callback_t
 * @return              none
 *****************************************************************************/
void BleDataRxCbRegister(ble_data_ready_callback_t data_rx_callback)
{
    data_ready_cb = data_rx_callback;
}

/*****************************************************************************
 * Function:            ProcessBleRxEvents()
 * Description:         Process BLE data 
 *
 * @param               spi_rcv_array
* @param                length
 * @return              none
 *****************************************************************************/
void ProcessBleRxEvents(uint8_t *spi_rcv_array, uint8_t len)
{
    static bool file_receiving_flag = false;
    
    if (spi_rcv_array[0] == BLE_SOF_CMD) {
        switch (spi_rcv_array[1])
        {
            case BLE_CONNECTION_EVNT_CMD:
                printf("Mobile device connected...\n\r");
                isDeviceConnected =true;                
                break;
                
            case BLE_REC_DATA_CMD:
                /*
                    when nRF UART send a packet to mDot board, we are incrementing
                    a counter and till count equals 3, we are appending data to
                    json Array.when it equals 3,ie 60 bytes(assuming that each time 
                    we are sening 20 bytes), passing this to callback to main
                    function.          
                */     
                       
              //  if(file_receiving_flag ==true)
               // {
             //   count++; 
                /*reassembling packets */
                memcpy(&json_array[file_index],&spi_rcv_array[3], (spi_rcv_array[2]-4));

            //    file_index+= (spi_rcv_array[2]-4);    //((spi_rcv_array[2]-4) contains packet length excluding headers                
                
             //   if(count ==3)   //added for testing. Need to change this to if(file_index == file_size)
           //     {
                    /*Passing the entire file to callback function*/
                   // data_ready_cb(json_array, file_index);
                    data_ready_cb(json_array, (spi_rcv_array[2]-4));
                    count= 0;
                    file_index =0;
                    /* Reset the File Parameters */
                    file_receiving_flag = false;
             //   }   
            // }                
                break;
                
            case BLE_DISCONNECTION_EVNT_CMD:
                printf("Mobile device disconnected...\n\r");
                isDeviceConnected =false;
                break;
                
            case BLE_START_OF_FILE:
            
                file_receiving_flag = true;

            /*extract the json string length from SOF. */               

                file_size = ((spi_rcv_array[3]<<8)|spi_rcv_array[4]);
                   
                break;
                
            case BLE_END_OF_FILE:                
                /* Reset the File Parameters */
                file_receiving_flag = false;
                break;  
                  
            default:
                printf("Unknown ID\n\r");
                break;            
        }
    } else {
        printf("SOF not found\n\r");
    }
}

/******************************************************************************/
/* END OF FILE                                                                */
/******************************************************************************/