/**
  ******************************************************************************
  * @file    ble_init.cpp
  * @author  Happiesstminds Firmware Team
  * @version v1.0
  * @date    4-Oct-2016
  * @brief   
  *
  ******************************************************************************
  * @attention
  *  
  *
  ******************************************************************************
  */

/******************************************************************************/
/* Include Files*/
/******************************************************************************/
#include "mbed.h"
#include "ble_main.h" 
#include "ble_spi.h"
#include "ble_msg_handler.h"
#include "ble_init.h"  
/******************************************************************************/
/* Local Defines                                                              */
/******************************************************************************/

/******************************************************************************/
/* Global Functions                                                           */
/******************************************************************************/

/*****************************************************************************
 * Function:            InitBLEModule()
 * Description:         initialise GPIo and SPI
 *
 * @param               BLE SPI Command
 * @return              status
 *****************************************************************************/
uint8_t BLE_INIT :: InitBLEModule(void)
{
    uint8_t status = SUCCESS;
   
   /*TODO
        wait(3) second delay need to be removed. This is added to make sure that 
        Nano BLE initialised first after a power on reset.
        Within 3 seconds, expecting Nano BLE init is succesfull and waiting 
        for the commands from mDOt.Need to check this delay on final hardware
    */
  
    wait(3);         
    status = InitSpiMaster();    
    printf("Initializing BLE..\n\r");
    return status;
}



/*****************************************************************************
 * Function:            SendCommand()
 * Description:         Send command to BLE
 *
 * @param               BLE SPI Command
 * @return              none
 *****************************************************************************/

static void SendCommand(uint8_t command)
{
    uint8_t packet[4];
              
    packet[0]= BLE_SOF_CMD;
    packet[1]= command;
    packet[2]= DATA_LENGTH;
    packet[3]= BLE_EOT_CMD;         
    WriteSpiData(packet,COMMAND_LENGTH);
}


/*****************************************************************************
 * Function:            send BLE init command()
 * Description:         Send command to BLE
 *
 * @param               none
 * @return              uint8_t status
 *****************************************************************************/
uint8_t BLE_INIT :: SendInitBleCommand(const uint8_t *device_name)
{   
    //TODO need to add device name in frame.
    uint8_t status;
    SendCommand(BLE_INIT_CMD);
    /*TODO
        The below two lines added for testing with custom board.This need to be
        changed.After sending the init command, mDot should read the response
        from slave.Poll the response and send init command till nano BLE returns
        success
    */ 
    SendCommand(BLE_INIT_CMD);
    SendCommand(BLE_INIT_CMD);
    
    return status;      //@SAGAR: Initialize status before returning
}


/*****************************************************************************
 * Function:            SetDeviceName()
 * Description:         Set BLE device name
 *
 * @param               none
 * @return              uint8_t status
 *****************************************************************************/
uint8_t BLE_INIT :: SetDeviceName(void)
{
    uint8_t status;
    /*TODO
    
        function to set BLE device name
    */    
    return status;
}

/*****************************************************************************
 * Function:            SetAdvertisingData()
 * Description:         set advertising data
 *
 * @param               none
 * @return              uint8_t status
 *****************************************************************************/
uint8_t BLE_INIT :: SetAdvertisingData(void)
{
   //TODO not implemented
   uint8_t status =SUCCESS;

   return status;
}

/*****************************************************************************
 * Function:            StartAdvertisingData()
 * Description:         Send startAdvertisingData Command 
 *
 * @param               none
 * @return              uint8_t status
 *****************************************************************************/
uint8_t StartAdvertisingData(void)
{
   uint8_t status =SUCCESS;
   SendCommand(BLE_START_ADV_CMD);
   return status;
}

/*****************************************************************************
 * Function:            SendBleData()
 * Description:         Send data over BLE (Max 20 bytes)
 *
 * @param               txBuf
  * @param              data length
 * @return              uint8_t status
 *****************************************************************************/
uint8_t BLE_INIT :: SendBleData(uint8_t *tx_buf, uint8_t len)
{
    uint8_t packet[24];
    uint8_t status = SUCCESS;        
    uint8_t packetlength;      
    packetlength = len + 4; 
    
    if(len<=20)
    {
        packet[0]= BLE_SOF_CMD;
        packet[1]= BLE_SEND_DATA_CMD;
        packet[2]= len;

        memcpy(&packet[3], tx_buf, len);
        packet[len + 3]= BLE_EOT_CMD;         
        WriteSpiData(packet, packetlength);
    }
    else
    {
        status = FAILURE;
    }
    return status;
}
/******************************************************************************/
/* END OF FILE                                                                */
/******************************************************************************/