/******************************************************************************
 *
 * File:                Control.cpp
 * Desciption:          ICE Control Class implementation for Output Thread
 *
 *****************************************************************************/
#include <Control.h>

//
// method:          getMappedState
// description:     convert the control state into its analytics code
//
// @param           none
// @return          relay-status code
//
int Control::getMappedState(void) const
{
    switch (controlType) {
        case CONTROL_TIMER:
        case CONTROL_SETPOINT:
        case CONTROL_COMPOSITE:
            return (state) ? RELAY_STATUS_AUTO_ON : RELAY_STATUS_AUTO_OFF;
        case CONTROL_MANUAL:
            return (state) ? RELAY_STATUS_MANUAL_ON : RELAY_STATUS_MANUAL_OFF;
        case CONTROL_FAILSAFE:
            return (state) ? RELAY_STATUS_FAILSAFE_ON : RELAY_STATUS_FAILSAFE_OFF;
        case CONTROL_PID:
        default:
            return -1;
    }
}
