// eep.c - EEPROM (AT24CM02)
// -------------------------------------------------------------------------------------------------

#include "mbed.h"
#include "global.h"
#include "eep.h"

// -------------------------------------------------------------------------------------------------
// globals

int eep_verbose = 0;

// -------------------------------------------------------------------------------------------------
// byte functions

unsigned char eep_get_byte(int dev, unsigned long addr)
{
    if(eep_verbose) printf("[eep_get_byte] dev=%d, addr=%u\r\n", dev, addr);

    unsigned char rbyte = 0;
    unsigned char dbyte = 0;
    unsigned char addr0 = 0;
    unsigned char addr1 = 0;

// build address bytes
    
    if     (dev == 0) dbyte = EE0_ADDR;
    else if(dev == 1) dbyte = EE1_ADDR;
    else
    {
        printf("[eep_get_byte] device error\r\n"); return(0);
    }

    if(addr < EEP_NBYT)
    {
        dbyte |= (addr & 0x00030000)>>16; // mask A17-A16 bits, add to dbyte
        addr0  = (addr & 0x0000FF00)>>8;  // mask A15-A08 bits
        addr1  = (addr & 0x000000FF);     // mask A07-A00 bits
    }
    else
    {
        printf("[eep_get_byte] address error\r\n"); return(0);
    }


    if(eep_verbose)
    {
        printf("   dbyte = 0x%x", dbyte);
        printf("   addr0 = 0x%x", addr0);
        printf("   addr1 = 0x%x\r\n", addr1);
    }

// perform read

    const int ldata = 2;
    char data[ldata];
    data[0] = addr0;
    data[1] = addr1;

    if(i2c->write(dbyte, data, 2, true )) if(eep_verbose) printf("no ack 1\r\n");
    if(i2c->read (dbyte, data, 1, false)) if(eep_verbose) printf("no ack 2\r\n");
    rbyte = data[0];

    return(rbyte);
}

void eep_set_byte(int dev, unsigned long addr, unsigned char wbyte)
{
    if(eep_verbose) printf("[eep_set_byte] dev=%d, addr=%u, wbyte=%u\r\n", dev, addr, wbyte);

    unsigned char dbyte = 0;
    unsigned char addr0 = 0;
    unsigned char addr1 = 0;

// build address bytes
    
    if     (dev == 0) dbyte = EE0_ADDR;
    else if(dev == 1) dbyte = EE1_ADDR;
    else
    {
        printf("[eep_set_byte] device error\r\n"); return;
    }

    if(addr < EEP_NBYT)
    {
        dbyte |= (addr & 0x00030000)>>16; // mask A17-A16 bits, add to dbyte
        addr0  = (addr & 0x0000FF00)>>8;  // mask A15-A08 bits
        addr1  = (addr & 0x000000FF);     // mask A07-A00 bits
    }
    else
    {
        printf("[eep_set_byte] address error\r\n"); return;
    }

    if(eep_verbose)
    {
        printf("   dbyte = 0x%x", dbyte);
        printf("   addr0 = 0x%x", addr0);
        printf("   addr1 = 0x%x", addr1);
        printf("   wbyte = 0x%x\r\n", wbyte);
    }

// perform read

    const int ldata = 3;
    char data[ldata];
    data[0] = addr0;
    data[1] = addr1;
    data[2] = wbyte;

    if(i2c->write(dbyte, data, ldata, false)) if(eep_verbose) printf("no ack\r\n");
}

// -------------------------------------------------------------------------------------------------
