#include "global.h"
#include <stdio.h>
#include <sstream>
#include <iostream>
#include "LogHandler.h"
#include "LogLocalApi.h"
#include "LoggerApi.h"
#include "BLEDataHandler.h"
#include "CloudFileReceiver.h"
#include "MTSLog.h"

Mail<LoggerQueue_t, 16> LoggerQueue;

size_t LoggerXmitLength = LOG_BYTES_PER_ENTRY;

int last_min=8;

bool LogHandler( bool joined )
{
    int32_t ret;
    char buffer[LOG_BYTES_PER_ENTRY];
    std::string tmp_buffer;
    bool log_in_eeprom=false;
    bool log_to_send=false;

    osEvent evt = LoggerQueue.get(50);
    if( (evt.status == osEventMail) ) {
        // pull the log event from the queue, even if we are not joined
        LoggerQueue_t *LoggerEvent = (LoggerQueue_t*)evt.value.p;
        logInfo("Log Msg Received: log entry: %s", LoggerEvent->log_entry);
        strncpy( buffer, LoggerEvent->log_entry, (LoggerXmitLength-1) );
        tmp_buffer.assign(buffer);
        log_to_send = true;
//        printf("%s:%d: Found Log Event on LoggerQueue to send to cloud\r\n", __func__, __LINE__);
        LoggerQueue.free(LoggerEvent);
    }

    if( (evt.status == osEventMail) && (joined == false) ) {
        // if we pulled a log from the queue put it in the EEPROM
        LogLocalApi( tmp_buffer.c_str() );
//        printf("%s:%d: Not Connected, Putting Logger event In EEPROM\r\n", __func__, __LINE__);
        return false;
    }

    if( (evt.status != osEventMail) && joined == true) {
        // nothing on the queue, see if there is anything in the EEPROM to send.
        log_in_eeprom = LogLocalApi_PopEntry( buffer );
        if( log_in_eeprom == true ) {
            tmp_buffer.assign(buffer);
            log_to_send = true;
//           printf("%s:%d: Found Log Event in EEPROM to send to cloud\r\n", __func__, __LINE__);
        } else {
//            printf("%s:%d: Nothing in EEPROM\r\n", __func__, __LINE__);
        }
    }

    if( log_to_send == false ) {
        struct tm       *ts;
        time_t curr_sec;

        curr_sec = time(0);
        ts = localtime(&curr_sec);
//        printf("curr_sec=%ld, min=%d (last=%d) min-mod-5=%d\r\n", curr_sec, ts->tm_min, last_min, (ts->tm_min%5) );
        if( ((ts->tm_min%1) == 0) && (ts->tm_min != last_min) ) {
            last_min = ts->tm_min;
            // no event log to send, send the heart beat message.
            printf("%s:%d: sending heart beat, hr=%d min=%d\r\n", __func__, __LINE__, ts->tm_hour, ts->tm_min);
            tmp_buffer = "{\"mtype\":\"20\"}";
        } else {
//            printf("%s:%d: Nothing to send to the cloud\r\n", __func__, __LINE__);
            if( CloudDataHandler_RcvFile != true ) {
                return false;
            }
            printf("%s:%d: currently receiveing a file\r\n", __func__, __LINE__);
            // send so we get another packet from gateway.
            tmp_buffer = "{\"mtype\":\"20\"}";
        }
    }

    if( joined == true ) {
        std::vector<uint8_t> data(tmp_buffer.begin(), tmp_buffer.end());
        if ((ret = GLOBAL_mdot->send(data)) == mDot::MDOT_OK) {
//            printf("%s:%d: Successful send to cloud\r\n", __func__, __LINE__);
            return true;
        }
//        printf("failed to send, ret=%d, %s\r\n", ret, mDot::getReturnCodeString(ret).c_str());
    }

    if( log_to_send == true ) {
        // We had a log event ready to send but didn't send it.
        // Store it in the EEPROM for the next attempt.
//        printf("%s:%d: Could not send Log Event to cloud, store in EEPROM\r\n", __func__, __LINE__);
        LogLocalApi( tmp_buffer.c_str() );
    } else {
//        printf("%s:%d: Could not send to cloud, nothing to store in EEPROM\r\n", __func__, __LINE__);
    }
    return false;
}

void CDH_ReplyToHandler( std::string &id, int status, float value )
{
    std::ostringstream reply_oss;
    
    LoggerQueue_t *LoggerEvent = LoggerQueue.alloc();
    memset( LoggerEvent->log_entry, 0, sizeof(LoggerEvent->log_entry) );

    reply_oss << "{  \"mtype\":1001, \"mbreply\":{ \"id\":\"" << id.c_str() << "\"," "\"status\":\"0\"," "\"value\":\"" << value << "\"} }";
    std::string string_reply = reply_oss.str();
    strncpy( LoggerEvent->log_entry, string_reply.c_str(), (sizeof(LoggerEvent->log_entry)-1));
    printf("%s:%d: Reply is: %s\r\n",__func__,__LINE__, LoggerEvent->log_entry);
    LoggerEvent->position = 0;
    LoggerQueue.put(LoggerEvent);
}

void ReplyToHandler( ThreadName_t replyTo, std::string &id, int ret, float value )
{
    if( replyTo == BLE_HANDLER ) {
   //     BLE_ReplyToHandler( id, ret, value );
    } else if( replyTo == CLOUD_DATA_HANDLER ) {
        CDH_ReplyToHandler( id, ret, value );
    } else {
        logError("Unknown Thread for Command Reply");
    }
}