#include "CloudFileReceiver.h"
#include "CloudDataHandler.h"
#include "MTSLog.h"
#include "global.h"
#include "cJSON.h"
#include <algorithm>

char CloudFileReceiverWriteBuf[MAX_FILE_SIZE];
char CloudFileReceiverReadBuf[MAX_FILE_SIZE];

bool StoreReceivedFile( mDot *dot, std::string &payload_string )
{
    FILENAME_STRING filename;

    memset( filename, '\0', sizeof(FILENAME_STRING) );
    
    cJSON * payload = cJSON_Parse(payload_string.c_str());
    int mType = cJSON_GetObjectItem(payload,"mtype")->valueint;
    logInfo("%s:%d: mtype=%d", __func__,__LINE__,mType);
    switch( mType ) {
        case SETPOINT_CONTROL_MTYPE: {
            cJSON * spcontrol = cJSON_GetObjectItem(payload,"spcontrol");
            logInfo("PROCESSING SETPONT CONTROL FILE");
            snprintf( filename, sizeof(FILENAME_STRING), "control_sp_%s.json", cJSON_GetObjectItem(spcontrol,"id")->valuestring );
            logInfo("SETPONT CONTROL FILENAME=%s", filename);

            memset( CloudFileReceiverWriteBuf, '\0', MAX_FILE_SIZE );
            snprintf(CloudFileReceiverWriteBuf, sizeof(CloudFileReceiverWriteBuf),
                     "{ "
                     "\"id\":           \"%s\", "
                     "\"priority\":     \"%s\","
                     "\"input\":        \"%s\", "
                     "\"output\":       \"%s\", "
                     "\"setpoint\":     \"%s\","
                     "\"prodfact\":     \"%s\","
                     "\"actingDir\":    \"%s\", "
                     "\"halert\":       \"%s\","
                     "\"lalert\":       \"%s\", "
                     "\"hfs\":          \"%s\","
                     "\"lfs\":          \"%s\", "
                     "\"tol\":          \"%s\"  }",
                     cJSON_GetObjectItem(spcontrol,"id")->valuestring,
                     cJSON_GetObjectItem(spcontrol,"priority")->valuestring,
                     cJSON_GetObjectItem(spcontrol,"input")->valuestring,
                     cJSON_GetObjectItem(spcontrol,"output")->valuestring,
                     cJSON_GetObjectItem(spcontrol,"setpoint")->valuestring,
                     cJSON_GetObjectItem(spcontrol,"productfact")->valuestring,
                     cJSON_GetObjectItem(spcontrol,"actingDir")->valuestring,
                     cJSON_GetObjectItem(spcontrol,"halert")->valuestring,
                     cJSON_GetObjectItem(spcontrol,"lalert")->valuestring,
                     cJSON_GetObjectItem(spcontrol,"hfs")->valuestring,
                     cJSON_GetObjectItem(spcontrol,"lfs")->valuestring,
                     cJSON_GetObjectItem(spcontrol,"tol")->valuestring
                    );
            cJSON_Delete(spcontrol);
            cJSON_Delete(payload);
            logInfo("saving string%s", CloudFileReceiverWriteBuf);
            bool status = GLOBAL_mdot->saveUserFile(filename, (void *)CloudFileReceiverWriteBuf, MAX_FILE_SIZE);
            if( status != true ) {
                logError("(%d)save file failed, status=%d", __LINE__, status);
            }

            // send a message to the configuration handler to create the control
            Message_t *msg  = MailBox.alloc();
            memset(msg, 0, sizeof(Message_t));
            msg->action  = ACTION_CREATE;
            msg->control = CONTROL_SETPOINT;
            strncpy(msg->controlFile, filename, sizeof(msg->controlFile)-1);

            printf("%s: Sending a create request for control %s type = %u\r\n", __func__, msg->controlFile, msg->control);

            MailBox.put(msg);
            break;
        }
#ifdef 0
        case MANUAL_CONTROL_MTYPE: {
            logInfo("PROCESSING MANUAL CONTROL FILE");
            snprintf( filename, sizeof(FILENAME_STRING), "control_mn_%s.json",
                      from_json["pay"]["mncontrol"]["id"].get<std::string>().c_str() );
            logInfo("MANUAL CONTROL FILENAME=%s", filename);

            memset( CloudFileReceiverWriteBuf, '\0', MAX_FILE_SIZE );
            snprintf(CloudFileReceiverWriteBuf, sizeof(CloudFileReceiverWriteBuf),
                     "{ "
                     "\"id\":           \"%s\",  "
                     "\"output\":       \"%s\",  "
                     "\"type\":         \"%s\",   "
                     "\"priority\":     \"%s\", "
                     "\"duration\":     \"%s\",   "
                     "\"setpoint\":     \"%s\",   "
                     "\"state\":        \"%s\",  "
                     "\"percent\":      \"%s\"  }",
                     from_json["pay"]["mncontrol"]["id"].get<std::string>().c_str(),
                     from_json["pay"]["mncontrol"]["output"].get<std::string>().c_str(),
                     from_json["pay"]["mncontrol"]["type"].get<std::string>().c_str(),
                     from_json["pay"]["mncontrol"]["priority"].get<std::string>().c_str(),
                     from_json["pay"]["mncontrol"]["duration"].get<std::string>().c_str(),
                     from_json["pay"]["mncontrol"]["setpoint"].get<std::string>().c_str(),
                     from_json["pay"]["mncontrol"]["state"].get<std::string>().c_str(),
                     from_json["pay"]["mncontrol"]["percent"].get<std::string>().c_str()
                    );

            logInfo("saving string%s", CloudFileReceiverWriteBuf);
            bool status = GLOBAL_mdot->saveUserFile(filename, (void *)CloudFileReceiverWriteBuf, MAX_FILE_SIZE);
            if( status != true ) {
                logError("(%d)save file failed, status=%d", __LINE__, status);
            }

            // send a message to the configuration handler to create the control
            Message_t *msg  = MailBox.alloc();
            memset(msg, 0, sizeof(Message_t));
            msg->action  = ACTION_CREATE;
            msg->control = CONTROL_MANUAL;
            strncpy(msg->controlFile, filename, sizeof(msg->controlFile)-1);

            printf("%s: Sending a create manual for control %s type = %u\r\n", __func__, msg->controlFile, msg->control);

            MailBox.put(msg);
            break;
        }
        case TIMER_CONTROL_MTYPE: {
            logInfo("PROCESSING TIMER CONTROL FILE");
            snprintf( filename, sizeof(FILENAME_STRING), "control_tm_%s.json",
                      from_json["pay"]["tmcontrol"]["id"].get<std::string>().c_str() );
            logInfo("TIMER CONTROL FILENAME=%s", filename);

            memset( CloudFileReceiverWriteBuf, '\0', MAX_FILE_SIZE );
            snprintf(CloudFileReceiverWriteBuf, sizeof(CloudFileReceiverWriteBuf),
                     "{ "
                     "\"id\":           \"%s\", "
                     "\"output\":       \"%s\", "
                     "\"priority\":     \"%s\", "
                     "\"starttime\":    \"%s\", "
                     "\"duration\":     \"%s\", ",
                     from_json["pay"]["tmcontrol"]["id"].get<std::string>().c_str(),
                     from_json["pay"]["tmcontrol"]["output"].get<std::string>().c_str(),
                     from_json["pay"]["tmcontrol"]["priority"].get<std::string>().c_str(),
                     from_json["pay"]["tmcontrol"]["starttime"].get<std::string>().c_str(),
                     from_json["pay"]["tmcontrol"]["duration"].get<std::string>().c_str()
                    );

            logInfo("saving string%s", CloudFileReceiverWriteBuf);
            bool status = GLOBAL_mdot->saveUserFile(filename, (void *)CloudFileReceiverWriteBuf, MAX_FILE_SIZE);
            if( status != true ) {
                logError("(%d)save file failed, status=%d", __LINE__, status);
            }

            // send a message to the configuration handler to create the control
            Message_t *msg  = MailBox.alloc();
            memset(msg, 0, sizeof(Message_t));
            msg->action  = ACTION_CREATE;
            msg->control = CONTROL_TIMER;
            strncpy(msg->controlFile, filename, sizeof(msg->controlFile)-1);

            printf("%s: Sending a create request for control %s type = %u\r\n", __func__, msg->controlFile, msg->control);

            MailBox.put(msg);
            break;
        }
        case INPUT_CONFIG_MTYPE:
        case VINPUT_CONFIG_MTYPE: {
            std::string vcmd;
            logInfo("id=%s", from_json["pay"]["input"]["id"].get<std::string>().c_str() );
            if( mType == INPUT_CONFIG_MTYPE ) {
                snprintf( filename, sizeof(FILENAME_STRING), "input_%s%s",
                          from_json["pay"]["input"]["id"].get<std::string>().c_str(),
                          ".json" );
                vcmd = "";

            } else {
                snprintf( filename, sizeof(FILENAME_STRING), "vinput_%s%s",
                          from_json["pay"]["input"]["id"].get<std::string>().c_str(),
                          ".json" );
                vcmd = from_json["pay"]["input"]["vcmd"].get<std::string>();
            }
            logInfo("INPUT CONFIG FILENAME=%s", filename);

            memset( CloudFileReceiverWriteBuf, '\0', MAX_FILE_SIZE );
            snprintf(CloudFileReceiverWriteBuf, sizeof(CloudFileReceiverWriteBuf),
                     "{ "
                     "\"id\":\"%s\", "
                     "\"name\":\"%s\", "
                     "\"units\":\"%s\", "
                     "\"min\":\"%s\", "
                     "\"max\":\"%s\", "
                     "\"node\":\"%s\", "
                     "\"reg\":\"%s\", "
                     "\"rtype\":\"%s\", "
                     "\"type\":\"%s\", "
                     "\"size\":\"%s\", "
                     "\"order\":\"%s\", "
                     "\"fmt\":\"%s\", "
                     "\"vcmd\":\"%s\", "
                     "\"rfreq\":\"%s\" } ",
                     from_json["pay"]["input"]["id"].get<std::string>().c_str(),
                     from_json["pay"]["input"]["name"].get<std::string>().c_str(),
                     from_json["pay"]["input"]["units"].get<std::string>().c_str(),
                     from_json["pay"]["input"]["min"].get<std::string>().c_str(),
                     from_json["pay"]["input"]["max"].get<std::string>().c_str(),
                     from_json["pay"]["input"]["node"].get<std::string>().c_str(),
                     from_json["pay"]["input"]["reg"].get<std::string>().c_str(),
                     from_json["pay"]["input"]["rtype"].get<std::string>().c_str(),
                     from_json["pay"]["input"]["type"].get<std::string>().c_str(),
                     from_json["pay"]["input"]["size"].get<std::string>().c_str(),
                     from_json["pay"]["input"]["order"].get<std::string>().c_str(),
                     from_json["pay"]["input"]["fmt"].get<std::string>().c_str(),
                     vcmd.c_str(),
                     from_json["pay"]["input"]["rfreq"].get<std::string>().c_str()
                    );

            logInfo("saving string%s", CloudFileReceiverWriteBuf);
            bool status = GLOBAL_mdot->saveUserFile(filename, (void *)CloudFileReceiverWriteBuf, MAX_FILE_SIZE);
            if( status != true ) {
                logError("(%d)save file failed, status=%d", __LINE__, status);
            }

            logInfo("Sending Mail To ModbusMasterMailBox, filename=%s", filename);
            Message_t *mail = ModbusMasterMailBox.alloc();
            mail->action = ACTION_READ_FILE;
            strncpy( mail->controlFile, filename, (sizeof(mail->controlFile)-1));
            ModbusMasterMailBox.put(mail);
            break;
        }
        case OUTPUT_CONFIG_MTYPE:
        case VOUTPUT_CONFIG_MTYPE: {
            logInfo("id=%s", from_json["pay"]["output"]["id"].get<std::string>().c_str() );
            if( mType == OUTPUT_CONFIG_MTYPE ) {
                snprintf( filename, sizeof(FILENAME_STRING), "output_%s%s",
                          from_json["pay"]["output"]["id"].get<std::string>().c_str(),
                          ".json" );
            } else {
                snprintf( filename, sizeof(FILENAME_STRING), "voutput_%s%s",
                          from_json["pay"]["output"]["id"].get<std::string>().c_str(),
                          ".json" );
            }
            logInfo("OUTPUT CONFIG FILENAME=%s", filename);

            memset( CloudFileReceiverWriteBuf, '\0', MAX_FILE_SIZE );
            snprintf(CloudFileReceiverWriteBuf, sizeof(CloudFileReceiverWriteBuf),
                     "{ "
                     "\"id\":\"%s\", "
                     "\"name\":\"%s\", "
                     "\"units\":\"%s\", "
                     "\"min\":\"%s\", "
                     "\"max\":\"%s\", "
                     "\"node\":\"%s\", "
                     "\"reg\":\"%s\", "
                     "\"rtype\":\"%s\", "
                     "\"type\":\"%s\", "
                     "\"size\":\"%s\", "
                     "\"order\":\"%s\", "
                     "\"fmt\":\"%s\", "
                     "\"rfreq\":\"%s\", "
                     "\"toperiod\":\"%s\", "
                     "\"scalelo\":\"%s\", "
                     "\"scalehi\":\"%s\" }",
                     from_json["pay"]["output"]["id"].get<std::string>().c_str(),
                     from_json["pay"]["output"]["name"].get<std::string>().c_str(),
                     from_json["pay"]["output"]["units"].get<std::string>().c_str(),
                     from_json["pay"]["output"]["min"].get<std::string>().c_str(),
                     from_json["pay"]["output"]["max"].get<std::string>().c_str(),
                     from_json["pay"]["output"]["node"].get<std::string>().c_str(),
                     from_json["pay"]["output"]["reg"].get<std::string>().c_str(),
                     from_json["pay"]["output"]["rtype"].get<std::string>().c_str(),
                     from_json["pay"]["output"]["type"].get<std::string>().c_str(),
                     from_json["pay"]["output"]["size"].get<std::string>().c_str(),
                     from_json["pay"]["output"]["order"].get<std::string>().c_str(),
                     from_json["pay"]["output"]["fmt"].get<std::string>().c_str(),
                     from_json["pay"]["output"]["rfreq"].get<std::string>().c_str(),
                     from_json["pay"]["output"]["toperiod"].get<std::string>().c_str(),
                     from_json["pay"]["output"]["scalelo"].get<std::string>().c_str(),
                     from_json["pay"]["output"]["scalehi"].get<std::string>().c_str()
                    );

            logInfo("saving string%s", CloudFileReceiverWriteBuf);
            bool status = GLOBAL_mdot->saveUserFile(filename, (void *)CloudFileReceiverWriteBuf, MAX_FILE_SIZE);
            if( status != true ) {
                logError("(%d)save file failed, status=%d", __LINE__, status);
            }

            // send a message to the modbus master
            logInfo("Sending Mail To ModbusMasterMailBox, filename=%s", filename);
            Message_t *mail = ModbusMasterMailBox.alloc();
            mail->action = ACTION_READ_FILE;
            strncpy( mail->controlFile, filename, (sizeof(mail->controlFile)-1));
            ModbusMasterMailBox.put(mail);

            // send a message to the output master
            logInfo("Sending mail to OutputMaster, filename = %s", filename);
            OutputControlMsg_t *output_mail = OutputMasterMailBox.alloc();
            output_mail->action = ACTION_NEW;
            strncpy(output_mail->controlFile, filename, sizeof(output_mail->controlFile)-1);
            OutputMasterMailBox.put(output_mail);
            break;
        }
        case DESTROY_SETPOINT_MTYPE: {
            logInfo("PROCESSING DESTORY SETPOINT CONTROL MESSAGE");
            snprintf( filename, sizeof(FILENAME_STRING), "control_sp_%s.json",
                      from_json["pay"]["destroy"]["id"].get<std::string>().c_str() );
            logInfo("SETPOINT CONTROL FILENAME=%s", filename);

            // send a message to the configuration handler to create the control
            Message_t *msg  = MailBox.alloc();
            memset(msg, 0, sizeof(Message_t));
            msg->action  = ACTION_DESTROY;
            msg->control = CONTROL_SETPOINT;
            strncpy(msg->controlFile, filename, sizeof(msg->controlFile)-1);

            printf("%s: Sending a destroy request for control %s type = %u\r\n", __func__, msg->controlFile, msg->control);

            MailBox.put(msg);
            break;
        }
        case DESTROY_MANUAL_MTYPE: {
            logInfo("PROCESSING DESTORY MANUAL CONTROL MESSAGE");
            snprintf( filename, sizeof(FILENAME_STRING), "control_mn_%s.json",
                      from_json["pay"]["destroy"]["id"].get<std::string>().c_str() );
            logInfo("MANUAL CONTROL FILENAME=%s", filename);

            // send a message to the configuration handler to create the control
            Message_t *msg  = MailBox.alloc();
            memset(msg, 0, sizeof(Message_t));
            msg->action  = ACTION_DESTROY;
            msg->control = CONTROL_MANUAL;
            strncpy(msg->controlFile, filename, sizeof(msg->controlFile)-1);

            printf("%s: Sending a destroy request for control %s type = %u\r\n", __func__, msg->controlFile, msg->control);

            MailBox.put(msg);
            break;
        }
        case DESTROY_TIMER_MTYPE: {
            logInfo("PROCESSING DESTORY TIMER CONTROL MESSAGE");
            snprintf( filename, sizeof(FILENAME_STRING), "control_tm_%s.json",
                      from_json["pay"]["destroy"]["id"].get<std::string>().c_str() );
            logInfo("TIMER CONTROL FILENAME=%s", filename);

            // send a message to the configuration handler to create the control
            Message_t *msg  = MailBox.alloc();
            memset(msg, 0, sizeof(Message_t));
            msg->action  = ACTION_DESTROY;
            msg->control = CONTROL_TIMER;
            strncpy(msg->controlFile, filename, sizeof(msg->controlFile)-1);

            printf("%s: Sending a destroy request for control %s type = %u\r\n", __func__, msg->controlFile, msg->control);

            MailBox.put(msg);
            break;
        }
        case VIRTUAL_COMMAND_MTYPE: {
            logInfo("PROCESSING VIRTUAL COMMAND FILE");
            snprintf( filename, sizeof(FILENAME_STRING), "vcmd_%s.json",
                      from_json["pay"]["vcommand"]["id"].get<std::string>().c_str() );
            logInfo("VIRTUAL COMMAND FILENAME=%s", filename);

            memset( CloudFileReceiverWriteBuf, '\0', MAX_FILE_SIZE );
            snprintf(CloudFileReceiverWriteBuf, sizeof(CloudFileReceiverWriteBuf),
                     "{"
                     "\"id\":\"%s\","
                     "\"tag\":\"%s\","
                     "\"c\":\"%f\","
                     "\"opl\":\"%s\","
                     "\"opr\":\"%s\","
                     "\"op\":\"%s\"}",
                     from_json["pay"]["vcommand"]["id"].get<std::string>().c_str(),
                     from_json["pay"]["vcommand"]["tag"].get<std::string>().c_str(),
                     atof(from_json["pay"]["vcommand"]["c"].get<std::string>().c_str()),
                     from_json["pay"]["vcommand"]["opl"].get<std::string>().c_str(),
                     from_json["pay"]["vcommand"]["opr"].get<std::string>().c_str(),
                     from_json["pay"]["vcommand"]["op"].get<std::string>().c_str()
                    );

            logInfo("saving string%s", CloudFileReceiverWriteBuf);
            bool status = GLOBAL_mdot->saveUserFile(filename, (void *)CloudFileReceiverWriteBuf, MAX_FILE_SIZE);
            if( status != true ) {
                logError("(%d)save file failed, status=%d", __LINE__, status);
            }

            logInfo("Sending Mail To ModbusMasterMailBox, filename=%s", filename);
            Message_t *mail = ModbusMasterMailBox.alloc();
            mail->action = ACTION_READ_FILE;
            strncpy( mail->controlFile, filename, (sizeof(mail->controlFile)-1));
            ModbusMasterMailBox.put(mail);
            break;
        }
        case BT_MODBUS_COMMAND_MTYPE: {
            logInfo("PROCESSING MODBUS COMMAND FILE");
            snprintf( filename, sizeof(FILENAME_STRING), "mcmd_%s.json",
                      from_json["pay"]["mcommand"]["id"].get<std::string>().c_str() );
            logInfo("MODBUS COMMAND FILENAME=%s", filename);

            memset( CloudFileReceiverWriteBuf, '\0', MAX_FILE_SIZE );
            snprintf(CloudFileReceiverWriteBuf, sizeof(CloudFileReceiverWriteBuf),
                     "{ "
                     "\"id\":\"%s\","
                     "\"node\":\"%s\","
                     "\"func\":\"%s\","
                     "\"sreg\":\"%s\","
                     "\"nreg\":\"%s\" }"
                     "\"dtype\":\"%s\","
                     "\"order\":\"%s\","
                     "\"value\":\"%s\"}",
                     from_json["pay"]["mcommand"]["id"].get<std::string>().c_str(),
                     from_json["pay"]["mcommand"]["node"].get<std::string>().c_str(),
                     from_json["pay"]["mcommand"]["func"].get<std::string>().c_str(),
                     from_json["pay"]["mcommand"]["sreg"].get<std::string>().c_str(),
                     from_json["pay"]["mcommand"]["nreg"].get<std::string>().c_str(),
                     from_json["pay"]["mcommand"]["dtype"].get<std::string>().c_str(),
                     from_json["pay"]["mcommand"]["order"].get<std::string>().c_str(),
                     from_json["pay"]["mcommand"]["value"].get<std::string>().c_str()
                    );

            logInfo("Sending Command To ModbusMasterMailBox: %s", CloudFileReceiverWriteBuf);
            Message_t *mail = ModbusMasterMailBox.alloc();
            mail->action = ACTION_EXEC_CMD;
            strncpy( mail->controlFile, CloudFileReceiverWriteBuf, (sizeof(mail->controlFile)-1));
            ModbusMasterMailBox.put(mail);
            break;
        }
#endif
        default:
            logInfo("DEFAULT");
            break;
    }
    return true;
}

bool CloudDataHandler_RcvFile = false;
bool CloudFileReceiver( std::string *recv_string, mDot *dot )
{
    bool status;
    CloudDataHandler_RcvFile = false;
    return true;

    cJSON * root = cJSON_Parse(recv_string->c_str());
    cJSON * payload = cJSON_GetObjectItem(root,"pay");
    std::string payload_string = cJSON_Print(payload);
    int sequence = cJSON_GetObjectItem(root,"seq")->valueint;
    logInfo("%s:%d: sequence=%d",__func__,__LINE__, sequence);
    cJSON_Delete(root);
    cJSON_Delete(payload);
    
    
    //remove the quotes added by the print function
//    payload_string.erase( payload_string.begin() );
//    payload_string.erase( payload_string.size() - 1 );
    
    payload_string = payload_string.substr(1, payload_string.size() - 2);
//    payload_string.erase( std::remove(payload_string.begin(), payload_string.end(), 'a'), payload_string.end() );
    std::replace( payload_string.begin(), payload_string.end(), '\\', ' ');
    
    printf("payload_string:%s\r\n", payload_string.c_str() );

    CloudDataHandler_RcvFile = false;
    if( sequence == -1 ) {

        // sequence of -1 means string sent in 1 chunk.
//        printf("%s:%d: payload=%s\r\n",__func__,__LINE__, payload_string.c_str() );
        status = StoreReceivedFile( dot, payload_string );

    } else if( sequence == 0 ) {

        memset(CloudFileReceiverWriteBuf,0,sizeof(CloudFileReceiverWriteBuf));
        snprintf(CloudFileReceiverWriteBuf, sizeof(CloudFileReceiverWriteBuf), "%s%s", "{\"seq\":-1, \"pay\":", payload_string.c_str() );

        logInfo("(%d)Writing String Length=%d, %s", __LINE__, MAX_FILE_SIZE, CloudFileReceiverWriteBuf );

        status = dot->saveUserFile("scratch.json", (void *)CloudFileReceiverWriteBuf, MAX_FILE_SIZE);
        if( status != true ) {
            logError("(%d)save file failed, status=%d", __LINE__, status);
        } else {
            CloudDataHandler_RcvFile = true;
            logInfo("(%d)UPDATED scratch.json FILE, status:%d, strlen=%d", __LINE__, status, strlen(CloudFileReceiverWriteBuf));
            __heapstats((__heapprt)fprintf,stderr); 
        }

    } else if( sequence == -2 ) {

        logInfo("(%d)READING BACK scratch.json FILE FOR LAST PACKET", __LINE__);

        // read the file back
        status = dot->readUserFile("scratch.json", (void *)CloudFileReceiverReadBuf, MAX_FILE_SIZE);
        if( status != true ) {
            logError("(%d)read file failed, status=%d", __LINE__, status);
            return false;
        }

        snprintf(CloudFileReceiverWriteBuf, sizeof(CloudFileReceiverWriteBuf), "%s%s%s", CloudFileReceiverReadBuf, payload_string.c_str(), "}" );
        logInfo("(%d)Final String Length=%d, %s", __LINE__, strlen(CloudFileReceiverWriteBuf), CloudFileReceiverWriteBuf );

        std::string final_json = CloudFileReceiverWriteBuf;
        printf("finished parse\r\n" );

        status = StoreReceivedFile( dot, final_json );
        if( status != true ) {
            logError("(%d)save file failed, status=%d", __LINE__, status);
        }

        status = dot->deleteUserFile("scratch.json");
        if( status != true ) {
            logError("(%d)delete file failed, status=%d", __LINE__, status);
        }

        logInfo("(%d)DELETED scratch.json FILE, status:%d", __LINE__, status );

    } else {

        logInfo("(%d)READING BACK scratch.json FILE", __LINE__);

        // read the file back
        status = dot->readUserFile("scratch.json", (void *)CloudFileReceiverReadBuf, MAX_FILE_SIZE);
        if( status != true ) {
            logError("(%d)read file failed, status=%d", __LINE__, status);
            return false;
        }

        snprintf(CloudFileReceiverWriteBuf, sizeof(CloudFileReceiverWriteBuf), "%s%s", CloudFileReceiverReadBuf, payload_string.c_str() );
        logInfo("(%d)Writing String Length=%d, %s", __LINE__, strlen(CloudFileReceiverWriteBuf), CloudFileReceiverWriteBuf );

        status = dot->saveUserFile("scratch.json", (void *)CloudFileReceiverWriteBuf, MAX_FILE_SIZE);
        if( status != true ) {
            logError("(%d)save file failed, status=%d", __LINE__, status);
        } else {
            CloudDataHandler_RcvFile = true;
            logInfo("(%d)UPDATED scratch.json FILE, status:%d, strlen=%d", __LINE__, status, strlen(CloudFileReceiverWriteBuf));
            __heapstats((__heapprt)fprintf,stderr); 
        }
    }
    return true;
}