/**
  ******************************************************************************
  * @file    ble_uart.cpp
  * @author  Happiesstminds Firmware Team
  * @version v1.0
  * @date    4-Oct-2016
  * @brief   
  *
  ******************************************************************************
  * @attention
  *  
  *
  ******************************************************************************
  */

/******************************************************************************/
/* Include Files*/
/******************************************************************************/
#include "mbed.h"
#include "ble_main.h" 
#include "ble_spi.h"
#include "ble_msg_handler.h"
#include "ble_init.h"


 
/******************************************************************************/
/* Global Functions                                                           */
/******************************************************************************/
BLE_INIT BLE_INIT;
extern volatile bool isDeviceConnected;
uint8_t temp_buf[30];
uint8_t dummy_bytes;
/*******************************************************************************
 * Function:            ConfigureBLEDevice()
 * Description:         Initialise and configure BLE
 *
 * @param               none
 * @return              none
 ******************************************************************************/
 
uint8_t BLE_FILE :: ConfigureBLEDevice(const uint8_t * device_name)
{
       
    uint8_t status = SUCCESS;
    BLE_INIT.InitBLEModule();            //initialising BLE SPI GPIO etc. 
    BLE_INIT.SetDeviceName();            //setting device name
    BLE_INIT.SetAdvertisingData();       //setting advdata
    BLE_INIT.SendInitBleCommand(device_name);       //initializing BLE
//    StartAdvertisingData();   //starting adv data
    return status;
}

/*****************************************************************************
 * Function:            GetBleConnectionState()
 * Description:         check whether device is connected or not
 *
 * @param               none
 * @return              uint8_t status(connected or disconnected)
 *****************************************************************************/

bool BLE_FILE :: GetBleConnectionState(void)
{
    return isDeviceConnected;
} 

/*****************************************************************************
 * Function:            SendSOF()
 * Description:         This function send Start of File transfer frame
 *
 * @param               tx_buf
* @param                data length
 * @return              none
 *****************************************************************************/
static uint8_t SendSOF(uint8_t *tx_buf, uint8_t len)
{

    uint8_t packet[24];
    uint8_t status = SUCCESS;        
    uint8_t packetlength;
 //   uint8_t array_length[10];        
    packetlength = len + 4; 
    
    packet[0]= BLE_SOF_CMD;
    packet[1]= BLE_START_OF_FILE;
    packet[2]= len;

    memcpy(&packet[3], tx_buf, len);
    packet[len + 3]= BLE_EOT_CMD;     
   
    WriteSpiData(packet, packetlength);
    return status;
}
/*****************************************************************************
 * Function:            SendEOF()
 * Description:         This function send End of File transfer frame
 *
 * @param               none
 * @return              none
 *****************************************************************************/
static void SendEOF(void)
{
    uint8_t packet[24];
  
    packet[0] =BLE_SOF_CMD;
    packet[1] =BLE_END_OF_FILE;
    packet[2] =20;
    packet[3] =0x45;
    packet[4] =0x4f;
    packet[5] =0x46;    
    memset(&packet[6], 0x40, 17);
    packet[23]=BLE_EOT_CMD;               
    WriteSpiData(packet,24);
}

/*****************************************************************************
 * Function:            SendFile()
 * Description:         This function receive the json file data and transmit 
                        data over BLE 
 *
 * @param               json file data
 * @param               data length
 * @return              none
 *****************************************************************************/
void BLE_FILE :: SendFile(uint8_t* json_file,uint8_t len)
{
    uint8_t num_writes,rem_bytes,start_index =0;   
    //  GetFileName();  //TODO
    /*added for testing purpose.Need to be removed*/
    num_writes = ((len)/MAX_PAYLOAD_BYTES);
    rem_bytes =((len)%MAX_PAYLOAD_BYTES);
    
    uint8_t file_name[20];
    file_name[0] =0x53;
    file_name[1] =0x4f;
    file_name[2] =0x46;
    file_name[3] = rem_bytes;
    memset(&file_name[4],0x40,17);
    
    /*TODO
    SOF consist of information about packets.Now sending a string for testing 
    with mobile app
    */ 
    SendSOF(file_name,16);        
    SendSOF(file_name,16);                     


    for(int i=0;i<(num_writes);i++)
    {
        BLE_INIT.SendBleData(&json_file[start_index], MAX_PAYLOAD_BYTES);
        start_index= start_index+MAX_PAYLOAD_BYTES;
    }
    if(rem_bytes)
    {
        dummy_bytes = 20-rem_bytes;
    //    BLE_INIT.SendBleData(&json_file[start_index], rem_bytes);
        memcpy(temp_buf,&json_file[start_index],rem_bytes);
        memset(&temp_buf[rem_bytes],0x40,dummy_bytes);
        BLE_INIT.SendBleData(temp_buf, MAX_PAYLOAD_BYTES);       
    }
    
    /*TODO
    EOF indication that packets transfer compleated.
    This information can be passed in SOF.    */        
    SendEOF();    

}


/******************************************************************************/
/* END OF FILE                                                                */
/******************************************************************************/