#include "mbed.h"
#include "datos.h"

#define longitudTrama 500

Timer timer;
float resultado;
int tiempo;

struct estructuraMedidas {
    float vrms;
    float irms;
    float potenciaActiva;
    float potenciaReactiva;
    float potenciaAparente;
    float energiaConsumida;
    float factorDePotencia;
};

float calcularRMS(int16_t *datos, int longitud);

void calcularDatos(int16_t *datosV, int16_t *datosI, int longitud, estructuraMedidas *medidas);


int main()
{

    timer.reset();
    timer.start();
    resultado=calcularRMS(datos, longitudTrama);
    timer.stop();
    printf("****El valor Vrms es %f calculado en %d us ****\n",resultado,timer.read_us());

    estructuraMedidas medidas;
    medidas.energiaConsumida=0;

    timer.reset();
    timer.start();
    calcularDatos(datosV,datosI,longitudTrama,&medidas);
    timer.stop();
    printf("**** Datos calculados en %d us ****\n",timer.read_us());
    printf("**** El valor Vrms es %f ****\n",medidas.vrms);
    printf("**** El valor Irms es %f ****\n",medidas.irms);
    printf("**** La potencia activa es %f ****\n",medidas.potenciaActiva);
    printf("**** La potencia reactiva es %f ****\n",medidas.potenciaReactiva);
    printf("**** La potencia aparente es %f ****\n",medidas.potenciaAparente);
    printf("**** La energia consumida es %f ****\n",medidas.energiaConsumida);
    printf("**** El factor de potencia es es %f ****\n",medidas.factorDePotencia);

}

float calcularRMS(int16_t *datos, int longitud)
{
    int i=0;
    int64_t acumulador=0;
    float vrms;
    
    for (i=0; i<longitud; i++) 
    {
        acumulador+=(datos[i]*datos[i]);
        
    }
    
    vrms=0.000100708*sqrt(((float)acumulador)/longitud);
    
    
    
    return vrms;

}


void calcularDatos(int16_t *datosV, int16_t *datosI, int longitud, estructuraMedidas *medidas)
{
    int i;
    int64_t acumulador=0;
    float vrms;
    float potac;
    float potap;
    float facpot;
    float potre;    
    
    for (i=0; i<longitud; i++) 
    {
        acumulador+=(datosV[i]*datosI[i]);
    }
    potac=(0.00000001014*acumulador)/longitud; 
    vrms=0.000100708*sqrt(((float)acumulador)/longitud); 
    potap=vrms*vrms;
    facpot=potac/potap;
    potre=potap*(sin(facpot));
    medidas->potenciaActiva=potac;
    medidas->vrms=vrms;
    medidas->irms=vrms;
    medidas->potenciaAparente=potap;
    medidas->factorDePotencia=facpot;
    medidas->potenciaReactiva=potre;
   
}

