#include "mbed.h"
#define bufferLength 500
#define muestras 200
#include "math.h"
#include "TextLCD.h"



TextLCD lcd(D8, D9, D2, D3, D4, D5, TextLCD::LCD16x2); // rs, e, d4-d7
Serial pc(USBTX, USBRX); // tx, rx


int contadorboton=1;


struct eResultados {
    float Vrms;
    float Vmax;
    float Vmin;
};

struct estructuraMedidas {
    float vrms;
    float irms;
    float potenciaActiva;
    float potenciaReactiva;
    float potenciaAparente;
    float energiaConsumida;
    float factorDePotencia;
};

estructuraMedidas medidas;


Serial blutooth(PC_0, PC_1);//Tx, Rx

AnalogIn    adc_in(A0);
AnalogIn    int_in(A1);
AnalogIn    cont_in(A3);
InterruptIn boton(USER_BUTTON);

Ticker tMuestrea;
Ticker tVisualiza;

void visualiza();
void procesado(int length,  int16_t *entrada, int16_t *entrada2);
void calcularDatos(int16_t *datosV, int16_t *datosI, int longitud, estructuraMedidas *medidas);
void calcularRMS(int16_t *buffer, int longitud,eResultados *resul);
void muestrea();

int flag=0;
int contador=1;
int bufferActivo=0;

struct buffers {
    int16_t vA[muestras];
    int16_t vB[muestras];
    int16_t iA[muestras];
    int16_t iB[muestras];
};


buffers bufferEntrada;
buffers bufferSalida;

eResultados resultados;

void flip()
{
    contadorboton++;
    if (contadorboton > 7) {
        contadorboton=1;
    }
}

int main()
{

    tMuestrea.attach_us(&muestrea, muestras);
    boton.rise(&flip);
    tVisualiza.attach(&visualiza, 1);
    blutooth.baud(9600);

    while(1) {
        if (flag==1) {

            flag=0;
            if(bufferActivo==1) {
                procesado(muestras,(int16_t *)&bufferEntrada.vA,(int16_t *)&bufferEntrada.iA);
            } else {
                procesado(muestras,(int16_t *)&bufferEntrada.vB,(int16_t *)&bufferEntrada.iB);
            }

        }

    }

}

void muestrea()
{
    int16_t dato=(int16_t)(adc_in.read_u16()^0x8000);
    int16_t dato2=(int16_t)(int_in.read_u16()^0x8000);
    int16_t cont=(int16_t)(cont_in.read_u16()^0x8000);

    if (bufferActivo==0) {

        bufferEntrada.vA[contador]=dato-cont;

        bufferEntrada.iA[contador]=dato2-cont;

    }

    else {

        bufferEntrada.vB[contador]=dato-cont;

        bufferEntrada.iB[contador]=dato2-cont;

    }

    contador++;
    if(contador>=muestras) {
        bufferActivo=!bufferActivo;
        contador=0;
        flag=1;
    }

}
void procesado(int length, int16_t *entrada, int16_t *entrada2)
{

    calcularDatos(entrada, entrada2,  100, &medidas);

}


void visualiza()
{
   
    blutooth.printf("%.3f|",medidas.vrms); //VRMS
    blutooth.printf("%.3f|",medidas.irms); //IRMS
    blutooth.printf("%.3f|",medidas.energiaConsumida/36000); //EnergiaConsumida
    blutooth.printf("%.3f|",medidas.factorDePotencia); //Factor de Potencia
    blutooth.printf("%.3f|",medidas.potenciaAparente); //Potencia Aparente
    blutooth.printf("%.3f|",medidas.potenciaActiva); //Potencia Activa
    blutooth.printf("%.3f|",medidas.potenciaReactiva); //Potencia Reactiva

    lcd.cls();
    switch (contadorboton) {
        case 1:
            lcd.printf ("VRMS\n%.3f V",medidas.vrms);
            break;
        case 2:
            lcd.printf ("irms\n%.3f A",medidas.irms);
            break;
        case 3:
            lcd.printf ("E consum\n%.3f W/s",medidas.energiaConsumida/36000);
            break;
        case 4:
            lcd.printf ("factor P\n%.3f",medidas.factorDePotencia);
            break;
        case 5:
            lcd.printf ("S\n%.3f VA",medidas.potenciaAparente);
            break;
        case 6:
            lcd.printf ("P\n%.3f W",medidas.potenciaActiva);
            break;
        case 7:
            lcd.printf ("Q\n%.3f VAr",medidas.potenciaReactiva);
            break;

    }

}

void calcularDatos(int16_t *datosV, int16_t *datosI, int longitud, estructuraMedidas *medidas)
{
    float consV=0.01447645724720217710371819960861;
  
  
    float consI=3.6915945822492998686005019138794e-4*1.1674827586206896551724137931034;
    float consP=consV*consI;

    int64_t sumaV=0;
    int64_t sumaI=0;
    int64_t sumaP=0;



    float datoV;
    float datoI;
    float datoP;
    float datoS;
    float datoQ;


    for (int i=0; i<longitud; i++) {

        sumaV+=datosV[i]*datosV[i];
        sumaI+=datosI[i]*datosI[i];
        sumaP+=datosV[i]*datosI[i];
    }

    datoV = consV*sqrt(((float)sumaV)/longitud);
    datoI = consI*sqrt(((float)sumaI)/longitud);
    datoP = consP*((float)sumaP)/longitud;
    datoS=datoV*datoI;
    datoQ = sqrt((datoS*datoS)-(datoP*datoP));

    (*medidas).energiaConsumida += datoP;
    (*medidas).factorDePotencia = datoP/datoS;
    (*medidas).potenciaAparente = datoS;
    (*medidas).potenciaActiva = datoP;
    (*medidas).potenciaReactiva = datoQ;
    (*medidas).vrms = datoV;
    (*medidas).irms = datoI;

}
