/**
 * Test program for configuration file interface class (Version 0.0.1)
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */
#include "mbed.h"
#include "ConfigFile.h"

ConfigFile cfg;
LocalFileSystem local("local");
//Serial pc(USBTX, USBRX); // tx, rx

/**
 * View the list.
 */
void viewlist(void) {
    /*
     * If you need to check all parameters.
     */
    const int cnt = cfg.getCount();
    char buf_key[BUFSIZ];
    char buf_value[BUFSIZ];
    for (int i = 0; i < cnt; i++) {
        if (cfg.getKeyAndValue(i, buf_key, sizeof(buf_key), buf_value, sizeof(buf_value))) {
            printf("No.%3d:'%s'='%s'\n", i, buf_key, buf_value);
        } else {
            printf("No.%3d:Failure to get a configuration.\n", i);
        }
    }
}

/**
 * ==================================================
 * Input file (input.cfg)
 * ==================================================
 * #
 * # Configuration file for mbed.
 * #
 *
 * MyKey1=This is a value for key1.
 * MyKey2=Value 2
 *
 * Message1 = This is a test message no.1
 *  Message2 = This is a test message no.2
 *   Message3 = This is a test message no.3
 *
 * ==================================================
 * Output file (output1.cfg)
 * ==================================================
 * MyKey1=This is a value for key1.
 * MyKey2=Value 2
 * Message1 = This is a test message no.1
 *  Message2  =  This is a test message no.2
 *   Message3   =   This is a test message no.3
 *
 * ==================================================
 * Output file (output2.txt)
 * ==================================================
 * # This is a configuration file for my application.
 * ABC=123
 * DEF=456
 *
 * ==================================================
 * Console output
 * ==================================================
 * 'MyKey1'='This is a value for key1.'
 * 'MyKey2'='Value 2'
 * 'Message1 '=' This is a test message no.1'
 * ' Message2  '='  This is a test message no.2'
 * '  Message3   '='   This is a test message no.3'
 *
 */
int ReadConfig() {

    char *key1 = "Baudrate";
    char *key2 = "Databits";
    char *key3 = "Parity ";
    char *key4 = "Stopbit";
    
    char *key5 = "USB-Ethernet";
    
    
    char value[BUFSIZ];

    /*
     * Read a configuration file from a mbed.
     */
    cfg.read("/local/input.cfg");

    /*
     * Read a configuration value.
     */
    if (cfg.getValue(key1, &value[0], sizeof(value))) {
        printf("'%s'='%s'\n", key1, value);
    }

    if (cfg.getValue(key2, &value[0], sizeof(value))) {
        printf("'%s'='%s'\n", key2, value);
    }

    if (cfg.getValue(key3, &value[0], sizeof(value))) {
        printf("'%s'='%s'\n", key3, value);
    }

    if (cfg.getValue(key4, &value[0], sizeof(value))) {
        printf("'%s'='%s'\n", key4, value);
    }

    if (cfg.getValue(key5, &value[0], sizeof(value))) {
        printf("'%s'='%s'\n", key5, value);
    }

    /*
     * Write a configuration file to a mbed.
     */
    cfg.write("/local/output1.cfg");

    /*
     * Remove all configurations.
     */
    cfg.removeAll();

    /*
     * Write a configuration value.
     */
    cfg.setValue("ABC", "123");
    cfg.setValue("DEF", "456");

    /*
     * Write a configuration file to a mbed.
     */
    cfg.write("/local/output2.cfg", "# This is a configuration file for my application.");

    while (1) {
    }
}
