// File: mbos_def2.h
// L. van der Kolk, ELVEDEKA, Holland

// -------------- Mbos definitions for CDU -------------------------------------------
// MBOS TASKS:
// ALIVE_TASK properties:
#define ALIVE_TASK_ID             1
#define ALIVE_TASK_PRIO          50
#define ALIVE_TASK_STACK_SZ     100    
// READ_POT_TASK properties: 
#define READ_POT_TASK_ID            4       
#define READ_POT_TASK_PRIO         40  // : lowest priority    
#define READ_POT_TASK_STACK_SZ    100
// RECEIVE_DECODE_TASK properties:
#define RECEIVE_DECODE_TASK_ID         2
#define RECEIVE_DECODE_TASK_PRIO      80  
#define RECEIVE_DECODE_TASK_STACK_SZ  256
// SEND_KEYMESSAGE_TASK properties:
#define SEND_KEYMESSAGE_TASK_ID         3
#define SEND_KEYMESSAGE_TASK_PRIO      90
#define SEND_KEYMESSAGE_TASK_STACK_SZ 256 
// CDU_DSP_CSS_TASK properties: 
#define CDU_DSP_CSS_TASK_ID            5
#define CDU_DSP_CSS_TASK_PRIO         95  // : highest priority !
#define CDU_DSP_CSS_TASK_STACK_SZ    512  

// MBOS TIMERS:
// ALIVE_TIMER properties:
#define ALIVE_TIMER_ID               1
#define ALIVE_TIMER_PERIOD        5000   // = 5 sec
// READ_POT_TIMER properties: 
#define READ_POT_TIMER_ID            2   
#define READ_POT_TIMER_PERIOD      100   // = 100msec scan time
// DECODE_TIMER properties:
#define DECODE_TIMER_ID              3   
#define DECODE_TIMER_PERIOD         50   // = 50msec scan time   

// MBOS EVENTS:
#define ALIVE_EVENT             1      
#define DECODE_TIMER_EVENT      2   
#define KEY_EVENT               4 
#define READ_POT_TIMER_EVENT    8   
#define FS_DATA_EVENT          16    

// MBOS RESOURCES:
// NOTE: priority should be higher than that of any task which will access the resource !
#define USB_TX_RESOURCE     2       // : for locking USB TX buffer
#define USB_TX_PRIO         99      // : USB TX buffer resource priority 
#define FS_DATA_RESOURCE    1       // : for locking FS data structures
#define FS_DATA_PRIO        97      // : FS data resource priority 

// -------------------------------------------------------------------------------------------  