#include "mbed.h"
#include <string>
#include "pins.h"

extern "C" void mbed_mac_address(char *mac); //for reading MAC Address
extern "C" void mbed_reset();                //reboot CDU

string CDU_Hardware()
{
    string cHardware = "HW version: ";
    char   buf[1];
    sprintf(buf, "%d", HW_VERSION_MAIN );
    cHardware += buf;
    cHardware += ".";
    sprintf(buf, "%d", HW_VERSION_SUB );
    cHardware += buf;
 return cHardware;
 }

string CDU_Firmware()
{
    string cFirmware = "FW version: ";
    char   buf[1];
    sprintf(buf, "%d", SW_VERSION_MAIN );
    cFirmware += buf;
    cFirmware += ".";
    sprintf(buf, "%d", SW_VERSION_SUB );
    cFirmware += buf;
return cFirmware;
}

string CDU_Compile()
{
    string cCompile = "FW UTC Timestamp: " ;
    cCompile += __DATE__; 
    cCompile += " ";
    cCompile += __TIME__;  
return cCompile  ;
}

string CDU_MAC()
{
    string cMac = "MAC address: ";
    char mac[6];
    char buf[1];
    mbed_mac_address(mac);
    for(int i=0; i<6;i++) 
        {
         if (i==5)
         {
            sprintf(buf, "%02X", mac[i]);             
         }
         else
         {
            sprintf(buf, "%02X:", mac[i]);
         }
         cMac += buf;
        }
    return cMac;
}

string CDU_IP()
{
    string cIP = "IP address: ";
    cIP += "000:000:000:000 (not defined)";
    return cIP;
}

void CDU_BOOT()
{
    mbed_reset();
}