/****************************************************************************/
/* This file contains entry points to setup and test procedures for the CDU */
/* Prerequisitions:                                                         */
/* 1. S-EXEC flag must be set to avoid interference from fs communications  */
/* 2. Keyboard interrupt routine must be redefined                          */
/****************************************************************************/

#include "mbed.h"
#include "TFT_4DGL.h"
#include "display.h"

#include <string>
using namespace std;

void CDU_ScreenAlign();
void CDU_displayclear();
void ExitKey( string cTitleText );

extern TFT_4DGL display; 
//extern void CDU_KB_INT_DISABLE(); //disable keyhandler and start internal keyhandler
extern int key_hit_ID;

//int righttext( string cString, int nChars, int nCharWidth )
//int centertext( string cString, int nChars, int nCharWidth )
extern char* str2char( string cString );
extern int righttext( string cString, int nChars, int nCharWidth );
extern int centertext( string cString, int nChars, int nCharWidth );


void CDU_Maint()
// Main selection screen SETUP and MAINT
{
    ExitKey( "CDU MAINTENANCE");
    display.graphic_string( str2char( "< SETUP" ), 0, LINE3, FONT_24X34, WHITE, 2, 2 ); 
    display.graphic_string( str2char( "LIGHT TEST >" ), righttext( "LIGHT TEST >", 24,24) , LINE3, FONT_24X34, WHITE, 2, 2 );     
    display.graphic_string( str2char( "KEYBOARD TEST >" ), righttext( "KEYBOARD TEST >", 24,24) , LINE5, FONT_24X34, WHITE, 2, 2 );         
    display.graphic_string( str2char( "FIRMWARE >" ), righttext( "FIRMWARE >", 24,24) , LINE9, FONT_24X34, WHITE, 2, 2 );
}

//Setup screens
void CDU_Setup()
{
    ExitKey( "CDU SETUP" );
    display.graphic_string( str2char( "< USB" ), 0, LINE3, FONT_24X34, WHITE, 2, 2 ); 
    display.graphic_string( str2char( "< ETHERNET" ), 0, LINE5, FONT_24X34, WHITE, 2, 2 ); 
    display.graphic_string( str2char( "DISPLAY SOURCE >" ), righttext( "DISPLAY SOURCE >", 24,24) , LINE9, FONT_24X34, WHITE, 2, 2 );     
}


void CDU_USB_Setup()
{
    ExitKey( "CDU USB SETUP" );
    display.graphic_string( str2char( "< BAUDRATE" ), 0, LINE3, FONT_24X34, WHITE, 2, 2 ); 
    display.graphic_string( str2char( "< DATABITS" ), 0, LINE5, FONT_24X34, WHITE, 2, 2 );        
    display.graphic_string( str2char( "< PARITY" ), 0, LINE7, FONT_24X34, WHITE, 2, 2 ); 
    display.graphic_string( str2char( "< STOPBITS" ), 0, LINE9, FONT_24X34, WHITE, 2, 2 ); 
}

void CDU_Ethernet_Setup()
{
    ExitKey( "CDU ETHERNET SETUP" );
    display.graphic_string( str2char( "< AUTO IP" ), 0, LINE3, FONT_24X34, WHITE, 2, 2 ); 
    display.graphic_string( str2char( "< IP ADDRESS" ), 0, LINE5, FONT_24X34, WHITE, 2, 2 );        
    display.graphic_string( str2char( "< GATEWAY" ), 0, LINE7, FONT_24X34, WHITE, 2, 2 ); 
    display.graphic_string( str2char( "< MAC ADDRESS" ), 0, LINE9, FONT_24X34, WHITE, 2, 2 );    
    
}


void CDU_Source_Setup()
{
    ExitKey( "CDU VIDEO SOURCE" );
    display.graphic_string( str2char( "< INTERNAL" ), 0, LINE3, FONT_24X34, WHITE, 2, 2 ); 
    display.graphic_string( str2char( "EXTERNAL >" ), righttext( "EXTERNAL >", 24,24) , LINE3, FONT_24X34, WHITE, 2, 2 );   
}



//Maintenance screens

void CDU_FW_Update()
{
    ExitKey( "FIRMWARE UPDATE" );
    display.graphic_string( str2char( "REBOOT CDU >" ), righttext( "REBOOT CDU >", 24,24) , LINE3, FONT_24X34, WHITE, 2, 2 );   
}

void CDU_LightTest()
{
    ExitKey( "CDU LIGHT TEST" );
    display.graphic_string( str2char( "< BACKLIGHT" ), 0, LINE3, FONT_24X34, WHITE, 2, 2 ); 
    display.graphic_string( str2char( "*=ON" ), centertext( "*=ON", 24, 24 ), LINE2, FONT_24X34, WHITE, 2, 2 ); 
    display.graphic_string( str2char( "----ANNUNCIATOR TEST----" ), 0, LINE4, FONT_24X34, WHITE, 2, 2 );  
       
    display.graphic_string( str2char( "< DSP" ), 0, LINE7, FONT_24X34, RED, 2, 2 );        
    display.graphic_string( str2char( "< FAIL" ), 0, LINE9, FONT_24X34, RED, 2, 2 ); 
    
    display.graphic_string( str2char( "EXEC >" ), righttext( "EXEC >", 24,24) , LINE5, FONT_24X34, GREEN, 2, 2 );  
    display.graphic_string( str2char( "MSG >" ),  righttext( "MSG >", 24,24) ,  LINE7, FONT_24X34, YELLOW, 2, 2 );  
    display.graphic_string( str2char( "OFST >" ), righttext( "OFST >", 24,24) , LINE9, FONT_24X34, YELLOW, 2, 2 );              
}

void CDU_KeyboardTest()
{
    ExitKey( "CDU KEYBOARD TEST");
    display.graphic_string( str2char( "KEYSCAN CODE: " ), 0, LINE6, FONT_24X34, WHITE, 2, 2 );   
    display.graphic_string( str2char( "FS KEY VALUE: " ), 0, LINE7, FONT_24X34, WHITE, 2, 2 ); 
    display.graphic_string( str2char( "PRESS 2x [EXEC]" ), 6, LINE12, FONT_24X34, WHITE, 2, 2 );        
}

void ExitKey( string cTitleText )
{
    //clear screen and place exit text
    CDU_displayclear();
    display.graphic_string( str2char( cTitleText ), centertext( cTitleText, 24, 24 ), LINE1, FONT_24X34, WHITE, 2, 2 ); 
    display.graphic_string( str2char( "< EXIT" ), 0, LINE13, FONT_24X34, WHITE, 2, 2 ); 
}

//Show all setup screens

void CDU_Screens()
{
    CDU_Maint();
    wait_ms( 4000 );
    
    CDU_Setup();
    wait_ms( 4000 );
    
    CDU_USB_Setup();
    wait_ms( 4000 );

    CDU_Ethernet_Setup();
    wait_ms( 4000 );
    
    CDU_Source_Setup();
    wait_ms( 4000 );
    
    CDU_LightTest();
    wait_ms( 4000);
    
    CDU_KeyboardTest();
    wait_ms( 4000 );

    CDU_FW_Update();
    wait_ms( 4000 );
   
}