#define HW_VERSION_1



#ifdef HW_VERSION_1
    //NOTE: THESE PIN DEFINITIONS ARE FOR HARDWARE VERSION 1.0
    //
    //*********************************
    //pins in main.cpp
    //*********************************
    //MODSERIAL SERIAL_DEBUG(p9, p10, 512, 64);  //: tx, rx
    #define MODSERIAL_TX        p9
    #define MODSERIAL_RX       p10
    //DigitalOut alive_led(LED1); // : LED 1 on Mbed board toggles when CDU is alive
    #define HEARTBEAT           LED1

    //*********************************
    //pins in display.cpp
    //*********************************
    //DigitalOut VGA_SOURCE( p7 ); //control line for video switch between INT and EXT video
    //DigitalOut VGA_SELECT( p8 ); //control line to select/deselect video switch
    #define VGA_SOURCE_SELECT   p7
    #define VGA_ON_OFF          p8 

    //Control lines for VGA driver board
    //TFT_4DGL display(p13,p14,p15); // serial tx, serial rx, reset pin
    #define VGA_TX              p13
    #define VGA_RX              p14
    #define VGA_RESET           p15

    //*********************************
    //pins in keyboard2.cpp
    //*********************************
    //CDU Keyboard communications KEYBOARD_INT
    //InterruptIn CDU_KB_INT( p5 );  //Set CDU keyboard interrupt line
    //I2C CDU_I2C(p28, p27);         //I2C bus for keyboard/temp chip.
    #define KBD_INT             p5
    #define I2C_SDA             p28
    #define I2C_SCL             p27

    //CDU Keyboard LEDS
    #define LED_EXEC            p12
    #define LED_FAIL            p17
    #define LED_DSPY            p18
    #define LED_MSG             p19
    #define LED_OFST            p20

    //CDU background lighting
    //AnalogIn BGL_POT( p16 ); //background light control potmeter
    //PwmOut BGL_LED( p21 );   //PWM output background lighting
    #define BACKLIGHT_SET       p16
    #define BACKLIGHT_DRIVE     p21

    //DigitalOut Key_led(LED2); // : LED 2 on Mbed board toggles when CDU key is pressed
    #define KEY_PRESSED         LED2
#endif


#ifdef HW_VERSION_2
    //NOTE: THESE PIN DEFINITIONS ARE FOR HARDWARE VERSION 2.0
    //
    //*********************************
    //pins in main.cpp
    //*********************************
    //MODSERIAL SERIAL_DEBUG(p9, p10, 512, 64);  //: tx, rx
    #define MODSERIAL_TX        p9
    #define MODESERIAL_RX       p10
    //DigitalOut alive_led(LED1); // : LED 1 on Mbed board toggles when CDU is alive
    #define HEARTBEAT           LED1

    //*********************************
    //pins in display.cpp
    //*********************************
    //DigitalOut VGA_SOURCE( p7 ); //control line for video switch between INT and EXT video
    //DigitalOut VGA_SELECT( p8 ); //control line to select/deselect video switch
    #define VGA_SOURCE_SELECT   p7
    #define VGA_ON_OFF          p8 

    //Control lines for VGA driver board
    //TFT_4DGL display(p14,p13,p12); // serial tx, serial rx, reset pin
    #define VGA_RESET           p12
    #define VGA_RX              p13
    #define VGA_TX              p14
    
    //*********************************
    //pins in keyboard2.cpp
    //*********************************
    //CDU Keyboard communications KEYBOARD_INT
    //InterruptIn CDU_KB_INT( p5 );  //Set CDU keyboard interrupt line
    //I2C CDU_I2C(p28, p27);         //I2C bus for keyboard/temp chip.
    #define KBD_INT             p5
    #define KBD_TMP_SDA         p28
    #define KBD_TMP_SCL         p27

    //CDU Keyboard LEDS
    #define LED_EXEC            p25
    #define LED_FAIL            p24
    #define LED_DSPY            p23
    #define LED_MSG             p22
    #define LED_OFST            p21

    //CDU background lighting
    //AnalogIn BGL_POT( p15 ); //background light control potmeter
    //PwmOut BGL_LED( p26 );   //PWM output background lighting
    #define BACKLIGHT_SET       p15
    #define BACKLIGHT_DRIVE     p26

    //DigitalOut Key_led(LED2); // : LED 2 on Mbed board toggles when CDU key is pressed
    #define KEY_PRESSED         LED2
#endif