// L. van der Kolk, ELVEDEKA, Holland 
// File:  CDU2FS_message_5.cpp 
//
// -- Message handling from CDU to FS --

#include "mbed.h"
#include "MODSERIAL.h"
#include "keys.h"
//#include "debug_lvdk.h" // : debug mode control

extern MODSERIAL USB;
extern MODSERIAL SERIAL_DEBUG;
extern int CDU_FS_interface;

int key_hit_ID = 0;   // : number of key that was hit, 0 = no hit of any key. ( global flag ! )

char key_message[25]   =  "$PCDUKEY,";  // : setup begin of KEY message to FS
char alive_message[25] =  "$PCDUOKE,";  // : setup begin of ALIVE message to FS

void send_message_to_FS(char *message_string) {
    // Common fnction to send a created message string (KEY or OKE) to the FS.
    // Parameter is pointer to char string that has to be sent.
    // Interface can be USB port or Ethernet port.
    int i = 0;
    if ( CDU_FS_interface == 0 ) {  // : messages will be sent out by USB port
        while (  message_string[i] != '\0' ) {
                   USB.putc(message_string[i]);
                   i++;
        }
    }
    if ( CDU_FS_interface == 1 )  { 
     // Messages will be sent out by Ehternet interface
     // -- Not implemented --
    }
}

void Send_ALIVE_message(int seconds){
    int i;
    char byte_read;
    char exor_byte = 0;
        //Create alive message:
        i = 9; // : i points to first place after "$PCDUOKE,"
        // Add seconds in 2 dec digits and a '*' char :
        sprintf(&alive_message[i],"%02d*",seconds); 
        // Calculate checksum now : 
        i = 1; // : i points to first place after '$'
        do { byte_read = alive_message[i];
             if (byte_read == '*') break; // : exclude '*' from exor calculation
             exor_byte = exor_byte ^ byte_read;
             i++;
        } while ( i < 20 );
        i++;  // : i now points to first digit of checksum after '*'
        // Add exor_byte in 2 hex chars (with upper case A-F) and a CR + LF:
        sprintf(&alive_message[i],"%02X\r\n",exor_byte); // : + extra NULL char added by sprintf 
        send_message_to_FS(alive_message); // : send message to FS       
}

void Send_KEY_message(int key_nr) {
        // Function creates a valid KEY message out of key_nr parameter.
        // Based on key_nr, a key char string is looked up and added to the message.
        // After adding a checksum, the total KEY message will be sent.
        int i;
        char byte_read;
        char exor_byte = 0;
        //  Create key message, starting with "$PCDUKEY," message header
        i = 9; // : i points to first position after "$PCDUKEY," message header 
        // Add key string to message string including '*' 
        if ( key_nr != 0 && key_nr < max_keys_CDUpanel ) {
             strcpy(&key_message[i],key_value[key_nr]); 
            // Calculate checksum now : 
            i = 1; // : i points to first place after '$' in message
            do { byte_read = key_message[i];
                if (byte_read == '*') break; // : exclude '*' from calculation
                exor_byte = exor_byte ^ byte_read;
                i++;
            } while ( i < 20 );
            i++;  // : i now points to first digit of checksum after '*'
            // Add exor_byte in 2 hex digits and a CR + LF:
            sprintf(&key_message[i],"%02X\r\n",exor_byte); // : extra NULL char added by sprintf
            send_message_to_FS(key_message); // : send message to FS
        } 
}           
        
   