// L. van der Kolk, ELVEDEKA, Holland //
// File:  show_data.cpp 

// -----  Testing only --------------------------------------------
// - Functions to test received and updated CDU data


#include "mbed.h"
#include "MODSERIAL.h"
#include "mbos.h"
#include "mbos_def.h"
#include "FS_datastructures.h"

extern mbos CDU_OS; 
extern MODSERIAL SERIAL_DEBUG;
static int command_cntr = 0;

void test_update_flags()
{
    // Tset if DCU data was updated:
    
// Background_Col_Update  : 1 when color was updated, must be reset to 0 when data has been read
// CDU_Status_Update      : 1 when status was updated, must be reset to 0 when data has been read
// DO_CLR_SCREEN          : 1 when screen should be cleared, must be reset to 0 when done
// Text_Line_Update       : equal to line number whose text was updated, must be reset to 0 when text has been read 
// Key_Maintext_Update    : equal to keynumber whose main text line was updated, must be reset to -1 text has been read
// Key_Subtext_Update     : equal to keynumber whose sub text line was updated, must be reset to -1 text has been read
  
  if ( Text_Line_Update != 0 ) {  //: textline was updated !
          // read textline data and print:
          SERIAL_DEBUG.printf("\rTextline updated:\r\n");          
          SERIAL_DEBUG.printf("line        : %d\r\n",Text_Line_Update );                         // show line nr 
          //SERIAL_DEBUG.printf("WTX begin pos   : %d\r\n",pos );                          // show begin position   
          SERIAL_DEBUG.printf("fontsize is : %d\r\n",TEXTLINE[Text_Line_Update].font_size );     // show fontsize 
          SERIAL_DEBUG.printf("fontstyle is: %c\r\n",TEXTLINE[Text_Line_Update].font_style);     // show fontstyle 
          SERIAL_DEBUG.printf("R_colour is : %d\r\n",TEXTLINE[Text_Line_Update].text_RED );      // show textcolour 
          SERIAL_DEBUG.printf("G_colour is : %d\r\n",TEXTLINE[Text_Line_Update].text_GREEN );    // show textcolour 
          SERIAL_DEBUG.printf("B_colour is : %d\r\n",TEXTLINE[Text_Line_Update].text_BLUE );     // show textcolour 
          SERIAL_DEBUG.printf("line text is: \r\n" );           
          SERIAL_DEBUG.printf("%s\r\n",TEXTLINE[Text_Line_Update].text );    // show line text
          command_cntr++;
          SERIAL_DEBUG.printf("command count : %d\r\n",command_cntr );    // : show counter for debugging
       
    }
        
    if ( Background_Col_Update != 0 ) {  // : background colour was updated
          // read new colour data and print: 
          SERIAL_DEBUG.printf("\rSBC command received:\r\n");
          SERIAL_DEBUG.printf("background R_colour : %d\r\n",BACKGROUND_COL.BG_RED);
          SERIAL_DEBUG.printf("background G_colour : %d\r\n",BACKGROUND_COL.BG_GREEN);
          SERIAL_DEBUG.printf("background B_colour : %d\r\n",BACKGROUND_COL.BG_BLUE);
          command_cntr++;
          SERIAL_DEBUG.printf("command count : %d\r\n",command_cntr );    // : show counter for debugging
        
    }            

    if ( CDU_Status_Update != 0 ) { // : CDU status was updated
         // read new status data and print: 
          SERIAL_DEBUG.printf("\r\r Setting command received :\r\n" );
          SERIAL_DEBUG.printf("Message indicator is : %d \r\n", CDU_STATUS.msg_indicator);
          SERIAL_DEBUG.printf("EXEC indicator is : %d \r\n", CDU_STATUS.exec_indicator);
          SERIAL_DEBUG.printf("Backlight is : %d \r\n", CDU_STATUS.backlight); 
          SERIAL_DEBUG.printf("Standby mode is : %d \r\n", CDU_STATUS.stby_mode);
          command_cntr++;
          SERIAL_DEBUG.printf("command count : %d\r\n",command_cntr );    // : show counter for debugging          
        
     }
        
     if ( DO_CLR_SCREEN != 0 ) {   // : clr screen request received
          SERIAL_DEBUG.printf("\r\r CLR screen request received :\r\n" );
          SERIAL_DEBUG.printf("DO_CLR_CSCREEN : %d \r\n", DO_CLR_SCREEN );
          command_cntr++;
          SERIAL_DEBUG.printf("command count : %d\r\n",command_cntr );    // : show counter for debugging
       
     }
     
     if (Key_Maintext_Update >= 0) {  // : key maintext was updated
                             
          SERIAL_DEBUG.printf("\rKey command received:\r\n"); 
          SERIAL_DEBUG.printf("Key number is : %d\r\n",Key_Maintext_Update);                            
          SERIAL_DEBUG.printf("Key MAINTEXT is : %s\r\n",SELKEY_MAINTEXT[Key_Maintext_Update].text );       // show text  
          SERIAL_DEBUG.printf("Keyfontsize is : %d\r\n",SELKEY_MAINTEXT[Key_Maintext_Update].font_size );  // show fontsize 
          SERIAL_DEBUG.printf("Key fontstyle is: %c\r\n",SELKEY_MAINTEXT[Key_Maintext_Update].font_style);  // show fontstyle 
          SERIAL_DEBUG.printf("Key R_colour is : %d\r\n",SELKEY_MAINTEXT[Key_Maintext_Update].text_RED );   // show textcolour 
          SERIAL_DEBUG.printf("Key G_colour is : %d\r\n",SELKEY_MAINTEXT[Key_Maintext_Update].text_GREEN ); // show textcolour 
          SERIAL_DEBUG.printf("Key B_colour is : %d\r\n",SELKEY_MAINTEXT[Key_Maintext_Update].text_BLUE );  // show textcolour 
           
         
     }
     
     if (Key_Subtext_Update >= 0) {  // : key subtext was updated
     
          SERIAL_DEBUG.printf("\rKey command received:\r\n"); 
          SERIAL_DEBUG.printf("Key number is : %d\r\n",Key_Subtext_Update);                            
          SERIAL_DEBUG.printf("Key SUBTEXT is  : %s\r\n",SELKEY_SUBTEXT[Key_Subtext_Update].text );       // show text  
          SERIAL_DEBUG.printf("Key fontsize is : %d\r\n",SELKEY_SUBTEXT[Key_Subtext_Update].font_size );  // show fontsize 
          SERIAL_DEBUG.printf("Key fontstyle is: %c\r\n",SELKEY_SUBTEXT[Key_Subtext_Update].font_style);  // show fontstyle 
          SERIAL_DEBUG.printf("Key R_colour is : %d\r\n",SELKEY_SUBTEXT[Key_Subtext_Update].text_RED );   // show textcolour 
          SERIAL_DEBUG.printf("Key G_colour is : %d\r\n",SELKEY_SUBTEXT[Key_Subtext_Update].text_GREEN ); // show textcolour 
          SERIAL_DEBUG.printf("Key B_colour is : %d\r\n",SELKEY_SUBTEXT[Key_Subtext_Update].text_BLUE );  // show textcolour     
          
         
     }
     
 /*   Text_Line_Update = 0;  // : reset FS data update ID flag
     Background_Col_Update = 0;  // : reset FS data update ID flag
     CDU_Status_Update = 0;   // : reset FS data update ID flag
     CDU_Status_Update = 0;   // : reset FS data update ID flag  
     DO_CLR_SCREEN = 0;
     Key_Maintext_Update = -1;
     Key_Subtext_Update = -1;
*/
       
}