// File: mbos_def.h
// L. van der Kolk, ELVEDEKA, Holland

// -------------- Mbos definitions for CDU -------------------------------------------
// ALIVE_TASK properties:
#define ALIVE_TASK_ID             1
#define ALIVE_TASK_PRIO          50
#define ALIVE_TASK_STACK_SZ     100    // : must be 100 to prevent stack overflow error!

// ALIVE_TIMER properties:
#define ALIVE_TIMER_ID            1
#define ALIVE_TIMER_PERIOD     5000   // = 5 sec

// RECEIVE_DECODE_TASK properties:
#define RECEIVE_DECODE_TASK_ID         2
#define RECEIVE_DECODE_TASK_PRIO      90   
#define RECEIVE_DECODE_TASK_STACK_SZ 256  // : must be 256 to prevent stack overflow error!

// SEND_KEYMESSAGE_TASK properties:
#define SEND_KEYMESSAGE_TASK_ID         3
#define SEND_KEYMESSAGE_TASK_PRIO      97
#define SEND_KEYMESSAGE_TASK_STACK_SZ 256  

// CDU_DSP_CSS_TASK properties: 
#define CDU_DSP_CSS_TASK_ID            5
#define CDU_DSP_CSS_TASK_PRIO         80
#define CDU_DSP_CSS_TASK_STACK_SZ    512 

// Mbos EVENTS:
#define ALIVE_EVENT             1      
#define RX_EVENT                2   // : Event caused by serial Rx interrupt
#define KEY_EVENT               4    
#define FS_DATA_EVENT          16    

// Mbos resources:
// NOTE: priority should be higher than that of any task which will access the resource !
#define USB_TX_RESOURCE     2       // : for locking USB TX buffer
#define USB_TX_PRIO         99      // : USB TX buffer resource priority 
#define FS_DATA_RESOURCE    1       // : for locking FS data structures
#define FS_DATA_PRIO        95      // : FS data resource priority 

// READ_POT_TIMER properties: 
#define READ_POT_TIMER_ID           2   
#define READ_POT_TIMER_PERIOD      100  // : 100msec scan time   
#define READ_POT_TIMER_EVENT        8   

// READ_POT_TASK properties: 
#define READ_POT_TASK_ID            4       
#define READ_POT_TASK_PRIO         40      
#define READ_POT_TASK_STACK_SZ    180      

#ifdef DEBUG_LVDK
//------------------------- LvdK test only! ---------------------------------------------
// SCAN_KEYS_TASK properties:   test only !
#define SCAN_KEYS_TASK_ID           4       
#define SCAN_KEYS_TASK_PRIO        40      
#define SCAN_KEYS_TASK_STACK_SZ   180       
// SCAN_KEYS_TIMER properties: ( LvdK button scan )
#define SCAN_KEYS_TIMER_ID           2  // : test only !
#define SCAN_KEYS_TIMER_PERIOD      50  // = 50msec , test only !
#define SCAN_KEYS_TIMER_EVENT        8  // : LvdK button scan timer event, test only !
//---------------------------------------------------------------------------------------- 
#endif 





