
#include "mbed.h"
#include "TFT_4DGL.h"
#include "keyboard.h"
#include "display.h"

#include <string> 
using namespace std;

// ---- FS-to-CDU data structures to be filled with received data --------------------------------
// Background colour of display:
struct { int   BG_RED;                 //  : RED value 
         int   BG_GREEN;               //  : GREEN value 
         int   BG_BLUE;                //  : BLUE value     
       } BACKGROUND_COL;

// Maintext lines at selectkeys:
struct { char  text[52];             //  : maintext string, ending with '\0'   
         int   font_size;            //  : fontsize of textline 0 or 1            
         char  font_style;           //  : style character S or N                       
         int   text_RED;             //  : RED value of textline
         int   text_GREEN;           //  : GREEN value of textline
         int   text_BLUE;            //  : BLUE value of textline
       } SELKEY_MAINTEXT[100];       //  : array of selectkey Maintext structures
        
// Subtext lines at selectkeys:
struct { char  text[52];             //  : subtext string, ending with '\0'   
         int   font_size;            //  : fontsize of textline 0 or 1                            
         char  font_style;           //  : style character S or N                        
         int   text_RED;             //  : RED value of textline
         int   text_GREEN;           //  : GREEN value of textline
         int   text_BLUE;            //  : BLUE value of textline
       } SELKEY_SUBTEXT[100];        //  : array of selectkey Subtext structures 

// Screen textlines:
struct { char  text[52];             //  : text line string, ending with '\0'   
         int   font_size;            //  : fontsize of textline 0 or 1         
         char  font_style;           //  : style character S or N                             
         int   text_RED;             //  : RED value of textline
         int   text_GREEN;           //  : GREEN value of textline
         int   text_BLUE;            //  : BLUE value of textline
         } TEXTLINE[15];             //  : array of textline structures
            
// CDU status:            
struct { int msg_indicator;       //  : MSG  0 = light OFF, 1 = light ON
                int exec_indicator;      //  : EXEC 0 = indicator OFF, 1 = indicator ON
                int fail_indicator;      //  : FAIL 0 = indicator OFF, 1 = indicator ON
                int dspy_indicator;      //  : DSPY 0 = indicator OFF, 1 = indicator ON  
                int ofst_indicator;      //  : OFST 0 = indicator OFF, 1 = indicator ON                              
                int backlight;           //  : 0 = light OFF, 1 = light ON 
                int stby_mode;           //  : 0 = operational mode, 1 = standby mode
              } CDU_STATUS;           
            

// FS_data_update_ID flags:
// These global flags indicate what data has been updated.
// Should be tested when FS_DATA_EVENT occurs.
int Background_Col_Update = 0 ;  // : 1 when color was updated, must be reset to 0 when data has been read
int CDU_Status_Update     = 0 ;  // : 1 when status was updated, must be reset to 0 when data has been read
int DO_CLR_SCREEN         = 0 ;  // : 1 when screen should be cleared, must be reset to 0 when done
int Text_Line_Update      = 0 ;  // : equal to line number whose text was updated, must be reset to 0 when text has been read 
int Key_Maintext_Update   = -1;  // : equal to keynumber whose main text line was updated, must be reset to -1 text has been read
int Key_Subtext_Update    = -1;  // : equal to keynumber whose sub text line was updated, must be reset to -1 text has been read

// ---- end of FS-to-CDU data structures --------------------------------------- --------------------------------

int key_hit_ID;
int FSData_received_flag = false;


//Driving Ethernet Jack LED's
/*
#define FIO1PIN (*(unsigned long*)0x2009C034UL) 
DigitalOut Green(p30), Yellow(p29);         //Leds are on pins 29 and 30 
Green = !(FIO1PIN&amp;(1&lt;&lt;25));       //Link
Yellow= !(FIO1PIN&amp;(1&lt;&lt;26));       //Speed
*/

//Pin definition prototypes
extern PwmOut BGL_LED;          //Background lighting for keypad
extern AnalogIn BGL_POT;        //Potmeter input for background lighting
extern InterruptIn CDU_KB_INT;  //Keyboard interrupt line
extern I2C CDU_I2C;             //I2C bus for keyboard/temp chip. Defined in keyboard.cpp

//VGA Control line definitions prototypes
extern DigitalOut VGA_SOURCE;  // control line for video switch between internal and external video
extern DigitalOut VGA_SELECT;  // select or deselect video switch
extern TFT_4DGL display;

//CDU screen prototypes declared in display.cpp
 void CDU_StartScreen();
 void CDU_ScreenAlign();
 void CDU_TestScreen();
 void CDU_LogoScreen();

//Keyboard Function prototypes
void CDU_KB_INT_ON( int p5);
void CDU_KB_GET_KEY();

//Temperature Sensor Function prototype
float CDU_GetTemp();

//String manipulation prototypes
char* str2char( string cString );
int centertext( string cString, int nChars, int nCharWidth );
int righttext( string cString, int nChars, int nCharWidth );

//Temporary stuff for testing
DigitalIn pb_up( p27 );
DigitalIn pb_dn( p28 );
DigitalOut led1(LED1);
DigitalOut led2(LED2); 


 
 int main() {
    char cText[24];
    int nLineCounter=0; 


    display.baudrate(9600); //115200
    //display.display_control(0x0c, 0x01); //Set resolution to 640*480
  
    CDU_StartScreen();
    wait_ms(2000);
    CDU_TestScreen();
    wait_ms(2000);    
    CDU_LogoScreen();
    wait_ms(2000);    
    CDU_ScreenAlign();
    wait_ms(2000);    
       
  
 
    while (! pb_dn )
    {}  
    
    display.cls(); 
    
    display.graphic_string( "PERF INIT" , 8*24,  LINE1, FONT_24X34, WHITE, 1, 1 );
    
    display.graphic_string( "GW/CRZ CG" , 0,  LINE2, FONT_12X34, WHITE, 1, 1 );
    display.graphic_string( "CRZ ALT"   , 41*12, LINE2, FONT_12X34, WHITE, 1, 1 ); 
    
    display.graphic_string( "___._ / 26.2%" , 0,  LINE3, FONT_24X34, WHITE, 1, 1 );
    display.graphic_string( "_____"     , 19*24, LINE3, FONT_24X34, WHITE, 1, 1 );

    display.graphic_string( "FUEL" , 0,  LINE4, FONT_12X34, WHITE, 1, 1 );
    display.graphic_string( "CRZ/WIND"   , 40*12, LINE4, FONT_12X34, WHITE, 1, 1 ); 
        
    display.graphic_string( "0.0" , 0,  LINE5, FONT_24X34, WHITE, 1, 1 );
    display.graphic_string( "000$ /---" , 15*24,  LINE5, FONT_24X34, WHITE, 1, 1 );
    
    display.graphic_string( "ZFW" , 0,  LINE6, FONT_12X34, WHITE, 1, 1 );
    display.graphic_string( "___._ " , 0,  LINE7, FONT_24X34, WHITE, 1, 1 );
    
    display.graphic_string( "RESERVES" , 0,  LINE8, FONT_12X34, WHITE, 1, 1 );
    display.graphic_string( "__._ " , 0,  LINE9, FONT_24X34, WHITE, 1, 1 );
         
    display.graphic_string( "COST INDEX" , 0,  LINE10, FONT_12X34, WHITE, 1, 1 );
    display.graphic_string( "TRANS ALT"   , 39*12, LINE10, FONT_12X34, WHITE, 1, 1 );  
    
    display.graphic_string( "___" , 0,  LINE11, FONT_24X34, WHITE, 1, 1 );
    display.graphic_string( "_____"     , 19*24, LINE11, FONT_24X34, WHITE, 1, 1 );
    
    display.graphic_string( "------------------------------------------------"   , 0, LINE12, FONT_12X34, WHITE, 1, 1 );  

    display.graphic_string( "<INDEX" , 0,  LINE13, FONT_24X34, WHITE, 1, 1 );
    display.graphic_string( "N1 LIMIT>"     , 15*24, LINE13, FONT_24X34, WHITE, 1, 1 );
    
    display.graphic_string( "SCRATCHPAD DATA LINE", righttext("SCRATCHPAD DATA LINE", 24, LARGECHAR) , LINE14, FONT_24X34, RED, 1, 1 );
   
    
    while (! pb_dn )
    {}  
    
    display.cls(); 
    sprintf( cText, "<--%03d", nLineCounter );
    display.graphic_string( cText , 0, nLineCounter, FONT_24X34, WHITE, 1, 1 );
    
    led1=1;
    wait_ms(100);
    led1=0;
    
    while (1)
    {
        if (pb_up)
         {
             nLineCounter++;
            if ( nLineCounter > 480 )
              {
               nLineCounter=480;
              }
            else 
              {
               display.graphic_string( "          " , 0, (nLineCounter-1), FONT_24X34, WHITE, 1, 1 );
               //display.text_string( "ABCDEFGHIJKLMNOPQRSTUVWX" , 0,(nLineCounter-1), FONT_24X34, WHITE );
              }
            
         }
        if (pb_dn)
         
         {
            nLineCounter--;
            if ( nLineCounter < 0 )
              {
              nLineCounter=0;
              }
            else
              {
              display.graphic_string( "                        " , 0, (nLineCounter+1), FONT_24X34, WHITE, 1, 1 );
              //display.text_string( "                        " , 0,(nLineCounter+1), FONT_24X34, WHITE );
              }
         }
    
     sprintf( cText, "<--%03d", nLineCounter );
     display.graphic_string( cText , 0, nLineCounter, FONT_24X34, WHITE, 1, 1 );

    }
    
 
}

