// L. van der Kolk, ELVEDEKA, Holland //
// File:  FS_datastructures.h 
// Global data structures containing updated data received from FS

// ---- FS-to-CDU data structures to be filled with received data ---------------------------------------------------------------------------

// Background colour of CDU display:
extern struct { int   BG_RED;            //  : RED value   0 - 255
                int   BG_GREEN;          //  : GREEN value 0 - 255
                int   BG_BLUE;           //  : BLUE value  0 - 255   
              } BACKGROUND_COL;

// Main text lines at selectkeys:
extern struct { char  text[52];          //  : maintext string, ending with '\0'   
                int   font_size;         //  : fontsize of textline 0 or 1            
                char  font_style;        //  : style character S or N                       
                int   text_RED;          //  : RED value of textline 0 - 255
                int   text_GREEN;        //  : GREEN value of textline 0 - 255
                int   text_BLUE;         //  : BLUE value of textline 0 - 255
              } SELKEY_MAINTEXT[];       //  : array of selectkey Maintext structures 
        
// Sub text lines at selectkeys:
extern struct { char  text[52];          //  : subtext string, ending with '\0'   
                int   font_size;         //  : fontsize of textline 0 or 1                            
                char  font_style;        //  : style character S or N                        
                int   text_RED;          //  : RED value of textline 0 - 255
                int   text_GREEN;        //  : GREEN value of textline 0 - 255
                int   text_BLUE;         //  : BLUE value of textline 0 - 255
              } SELKEY_SUBTEXT[];        //  : array of selectkey Subtext structures 

// Screen textlines:
extern struct { char  text[52];          //  : text line string, ending with '\0'   
                int   font_size;         //  : fontsize of textline 0 or 1         
                char  font_style;        //  : style character S or N                             
                int   text_RED;          //  : RED value of textline  0 - 255
                int   text_GREEN;        //  : GREEN value of textline 0 - 255
                int   text_BLUE;         //  : BLUE value of textline 0 - 255
              } TEXTLINE[];              //  : array of textline structures
            
// CDU status:            
extern struct { int msg_indicator;       //  : MSG  0 = light OFF, 1 = light ON
                int exec_indicator;      //  : EXEC 0 = indicator OFF, 1 = indicator ON
                int fail_indicator;      //  : FAIL 0 = indicator OFF, 1 = indicator ON
                int dspy_indicator;      //  : DSPY 0 = indicator OFF, 1 = indicator ON  
                int ofst_indicator;      //  : OFST 0 = indicator OFF, 1 = indicator ON                              
                int backlight;           //  : 0 = light OFF, 1 = light ON 
                int stby_mode;           //  : 0 = operational mode, 1 = standby mode
              } CDU_STATUS;           


// FS_data_update_ID:
// These global flags indicate what data has been updated.
// Should be tested when FS_DATA_EVENT occurs.
extern int Background_Col_Update;    // : 1 when color was updated, must be reset to 0 when data has been read
extern int CDU_Status_Update    ;    // : 1 when status was updated, must be reset to 0 when data has been read
extern int DO_CLR_SCREEN        ;    // : 1 when screen should be cleared, must be reset to 0 when done
extern int Text_Line_Update     ;    // : equal to line number whose text was updated, must be reset to 0 when text has been read 
extern int Key_Maintext_Update  ;    // : equal to keynumber whose main text line was updated, must be reset to -1 (!)when text has been read
extern int Key_Subtext_Update   ;    // : equal to keynumber whose sub text line was updated, must be reset to -1 (!) when text has been read

