#include "mbed.h"
#include "temperature.h"

// Read temperature from LM75BD
 
extern I2C CDU_I2C;                 //I2C bus on i2c(p28, p27) for keyboard/temp chip. Defined in keyboard.cpp
const int CDU_TMP_ADRS = 0x90;      //Default hardware address of LM75B chip
 
float CDU_GetTemp() {
    char cmd[2];
        
        //Init LM75B
        cmd[0] = REG_CONFIG;  //Pointer byte (0x01=configuration register)
        cmd[1] = CONFIG_NORMAL;  //Configuration byte (0x00=normal configuration)
        CDU_I2C.write(CDU_TMP_ADRS, cmd, 2); //Write bytes to bus
        
        //Read temperature
        cmd[0] = REG_TEMP;  //Pointer byte (0x00=temperature register)
        CDU_I2C.write(CDU_TMP_ADRS, cmd, 1);    //write to device
        CDU_I2C.read(CDU_TMP_ADRS, cmd, 2);     //read temperature 2 data bytes
        
        /*
        Convert from 2's complement to Degrees Celsius
        1. If the Temp data MSByte bit D10 = 0, then the temperature is positive and Temp value (C) = +(Temp data) x 0.125 C.
        2. If the Temp data MSByte bit D10 = 1, then the temperature is negative and Temp value (C) = (two’s complement of Temp data) x 0.125 C.
        */
        float tmp = (float((cmd[0]<<8)|cmd[1]) / 256.0);
        return ( tmp );
}

