#include "mbed.h"
#include "TFT_4DGL.h"
#include "display.h"
#include "fs_datastructures.h"

#include <string> 
using namespace std;


// ---- FS-to-CDU data structures filled with received data ---------------------------------------

#define max_text0    48   //  max text length font 0      
#define max_text1    24   //  max text length font 1  
#define max_lines    14   //  max nr of screen lines 
#define max_font      1   //  possible fonts are 0 to max_font, so now 0 and 1 possible
#define max_col_nr  255   //  highest possible R,G, or B colour number
#define fstyle_1     'S'  //  possible font style character 1
#define fstyle_2     'N'  //  possible font style character 2
#define max_keys    100   //  max total nr of select keys 0 - 99
#define max_leftkeys  6   //  max nr of used LEFT select keys ( 0 - 49 )
#define max_rightkeys 6   //  max nr of used RIGHT select keys ( 50 - 99 )

extern int FSdata_received_flag;    //Prototype of data flag (declared in main.cpp)
extern TFT_4DGL display;            //Prototype of Display Driver (declared in display.cpp)

//Prototype of indicators (declared in keyboard.cpp)
extern DigitalOut EXEC;
extern DigitalOut FAIL;
extern DigitalOut DSPY;
extern DigitalOut  MSG;
extern DigitalOut OFST;

extern void CDU_SET_BGL_INTENSITY( int nVal );      //Prototype of function controlling CDU backlight (declared in keyboard.cpp)
extern int nFontSize( int nfont_number );           //Prototype of function for fontselection (declared in display.cpp)
extern int nFontWidth (int nfont_number );          //Prototype of function to retrieve font width (declared in display.cpp)
extern int nLine2Pixel( int nLine );                //Prototype of function to calculate vertical pixelposition from line number (declared in display.cpp)
extern int LeftOrRight( int nTextLine, string cString, int nChars, int nCharWidth ); //declared in display.cpp
extern unsigned int cRGB( char cRED, char cGREEN, char cBLUE ); //Prototype of function for assembly color word (declared in display.cpp)

// FS_data_update_ID:
// These global flags indicate what data has been updated.
// Should be tested when FS_DATA_EVENT occurs.
extern int Background_Col_Update;    // 1 when color was updated, must be reset to 0 when data has been read
extern int CDU_Status_Update    ;    // 1 when status was updated, must be reset to 0 when data has been read
extern int DO_CLR_SCREEN        ;    // 1 when screen should be cleared, must be reset to 0 when done
extern int Text_Line_Update     ;    // equal to line number whose text was updated, must be reset to 0 when text has been read 
extern int Key_Maintext_Update  ;    // equal to keynumber whose main text line was updated, must be reset to -1 (!)when text has been read
extern int Key_Subtext_Update   ;    // equal to keynumber whose sub text line was updated, must be reset to -1 (!) when text has been read

// Common flag to signal that one or more updates were performed:
int FSdata_received_flag = false;  //  : true when one or more FS-to-CDU data structures were updated
                                   
// --------------------------------------------------------------------------------------------------

void CDU_DSP_CSS()
/*Check flags to see if action is required
Background_Col_Update;    // : 1 when color was updated, must be reset to 0 when data has been read
CDU_Status_Update    ;    // : 1 when status was updated, must be reset to 0 when data has been read
DO_CLR_SCREEN        ;    // : 1 when screen should be cleared, must be reset to 0 when done
Text_Line_Update     ;    // : equal to line number whose text was updated, must be reset to 0 when text has been read 
Key_Maintext_Update  ;    // : equal to keynumber whose main text line was updated, must be reset to -1 (!)when text has been read
Key_Subtext_Update   ;    // : equal to keynumber whose sub text line was updated, must be reset to -1 (!) when text has been read
*/
    
{
    int nLine = 1;  //default value
    //check common flag
    if ( FSdata_received_flag )
    //if set, check all structures and lock dynamic storage
    {
        if ( Background_Col_Update == 1)
        {
            display.background_color( cRGB( BACKGROUND_COL.BG_RED, BACKGROUND_COL.BG_GREEN, BACKGROUND_COL.BG_BLUE ) );
            Background_Col_Update = 0;
        }
        
        if ( Key_Maintext_Update > -1 )
            //Key_Maintext_Update contains the line number 00-49 is LSK text, 50-99 is RSK text
            //Currently used:
            //00-14 left  side of screen --> left  adjust, horizontal position = 0
            //50-64 right side of screen --> right adjust, horizontal position calculated with righttext() (declared in display.cpp)
            
            //00 = LSK1         50 = RSK1   Print on LINE 3
            //01 = LSK2         51 = RSK2   Print on LINE 5
            //02 = LSK3         52 = RSK3   Print on LINE 7
            //03 = LSK4         53 = RSK4   Print on LINE 9
            //04 = LSK5         54 = RSK5   Print on LINE 11
            //05 = LSK6         55 = RSK6   Print on LINE 13
        {
            switch ( Key_Maintext_Update )
            {
                case ( 00 ): nLine = 3; break;
                case ( 50 ): nLine = 3; break;
                case ( 01 ): nLine = 5; break;
                case ( 51 ): nLine = 5; break;
                case ( 02 ): nLine = 7; break;
                case ( 52 ): nLine = 7; break;
                case ( 03 ): nLine = 9; break;
                case ( 53 ): nLine = 9; break;
                case ( 04 ): nLine = 11; break;
                case ( 54 ): nLine = 11; break;
                case ( 05 ): nLine = 13; break;
                case ( 55 ): nLine = 13; break;
            }
            //display.graphic_string(char *s, int x, int y, char font, int color, char width multiplier, char height multiplier)
            display.graphic_string( SELKEY_MAINTEXT[Key_Maintext_Update].text ,                         //Text to display
                                    LeftOrRight( Key_Maintext_Update, SELKEY_MAINTEXT[Key_Maintext_Update].text,24,24 )*nFontWidth( SELKEY_MAINTEXT[Key_Maintext_Update].font_size ) ,    //Horizontal position
                                    nLine2Pixel( nLine ),                                 //Vertical position
                                    nFontSize( SELKEY_MAINTEXT[Key_Maintext_Update].font_size ),        //Font
                                    cRGB( SELKEY_MAINTEXT[Key_Maintext_Update].text_RED ,SELKEY_MAINTEXT[Key_Maintext_Update].text_GREEN ,SELKEY_MAINTEXT[Key_Maintext_Update].text_BLUE ), 
                                    1, 1 );
            Key_Maintext_Update = -1;
        }
        
        if ( Key_Subtext_Update > -1 )
            //Key Subtext_Update contains the line number 00-49 is LSK subtext, 50-99 is RSK subtext
            //Currently used:
            //00-14 left  side of screen --> left  adjust, horizontal position = 0
            //50-64 right side of screen --> right adjust, horizontal position calculated with righttext() (declared in display.cpp)            
            //00 = LSK1         50 = RSK1   Print on LINE 2
            //01 = LSK2         51 = RSK2   Print on LINE 4
            //02 = LSK3         52 = RSK3   Print on LINE 6
            //03 = LSK4         53 = RSK4   Print on LINE 8
            //04 = LSK5         54 = RSK5   Print on LINE 10
            //05 = LSK6         55 = RSK6   Print on LINE 12
        {
            switch ( Key_Maintext_Update )
            {
                case ( 00 ): nLine = 2; break;
                case ( 50 ): nLine = 2; break;
                case ( 01 ): nLine = 4; break;
                case ( 51 ): nLine = 4; break;
                case ( 02 ): nLine = 6; break;
                case ( 52 ): nLine = 6; break;
                case ( 03 ): nLine = 8; break;
                case ( 53 ): nLine = 8; break;
                case ( 04 ): nLine = 10; break;
                case ( 54 ): nLine = 10; break;
                case ( 05 ): nLine = 12; break;
                case ( 55 ): nLine = 12; break;
            }
            //display.graphic_string(char *s, int x, int y, char font, int color, char width multiplier, char height multiplier)            
            display.graphic_string( SELKEY_SUBTEXT[Key_Subtext_Update].text ,                       //Text to display
                                    LeftOrRight( Key_Subtext_Update, SELKEY_SUBTEXT[Key_Subtext_Update].text,12,48 )*nFontWidth( SELKEY_SUBTEXT[Key_Subtext_Update].font_size ) ,  //Horizontal position
                                    nLine2Pixel( nLine ),                              //Vertical position
                                    nFontSize( SELKEY_SUBTEXT[Key_Subtext_Update].font_size ),      //Font
                                    cRGB( SELKEY_SUBTEXT[Key_Subtext_Update].text_RED ,SELKEY_SUBTEXT[Key_Subtext_Update].text_GREEN ,SELKEY_SUBTEXT[Key_Subtext_Update].text_BLUE ), 
                                    1, 1 ); //multiplier always on 1
            Key_Subtext_Update = -1;
        }
        
        if ( Text_Line_Update > 0)
        {
            //Text_Line_Update contains the the line number to write
             display.graphic_string( TEXTLINE[Text_Line_Update].text ,                      //Text to display
                                    0,                                                      //Horizontal position always 0
                                    nLine2Pixel( Text_Line_Update ),                        //Vertical position
                                    nFontSize( TEXTLINE[Text_Line_Update].font_size ),      //Font
                                    cRGB( TEXTLINE[Text_Line_Update].text_RED ,TEXTLINE[Text_Line_Update].text_GREEN ,TEXTLINE[Text_Line_Update].text_BLUE ), 
                                    1, 1 ); //multiplier always on 1
            Text_Line_Update = 0;
        }
        
        if ( CDU_Status_Update == 1 )
        {
 /*                            
                CDU_STATUS.stby_mode;           //  : 0 = operational mode, 1 = standby mode
*/          if ( CDU_STATUS.backlight )         // Backlight control
            {
                CDU_SET_BGL_INTENSITY( 255 );
            } 
            else
            {
                CDU_SET_BGL_INTENSITY( 0 );  
            }
            // Set CDU indicators
            MSG  = CDU_STATUS.msg_indicator;
            EXEC = CDU_STATUS.exec_indicator;
            FAIL = CDU_STATUS.fail_indicator;
            DSPY = CDU_STATUS.dspy_indicator;
            OFST = CDU_STATUS.ofst_indicator;

            CDU_Status_Update =0;
        }
        if ( DO_CLR_SCREEN )
        {
            display.cls();
            DO_CLR_SCREEN =0;
        }
    }
    //Reset global flag and release lock on dynamic storage
    FSdata_received_flag = false ;
}    

/*
void GET_NEW_DATA_TASK(void) // : read new screendata from FS datastructures
{    
    while(1) {  // : loop forever because it is a mbos taskfunction      
    CDU_OS.WaitEvent(FS_DATA_EVENT);
    CDU_OS.LockResource(FS_DATA_RESOURCE);   //lock resource to prevent intermediate updates
    CDU_CSS()
    CDU_OS.FreeResource(FS_DATA_RESOURCE);   //free resource
    }
}
*/