#include "mbed.h"
#include "string.h"
#include "ctype.h"
#include <stdlib.h>

#define DOT 0.1
#define DASH .4
#define PAUSE 0.2

DigitalOut red(LED_RED);
DigitalOut green(LED_GREEN);

void pisca(float time)
{
    green = 0;
    wait(time);
    green = 1;
    wait(PAUSE);
}

void piscaErro(float time)
{
    red = 0;
    wait(time);
    red = 1;
    wait(PAUSE);
}


char* charToMorse(char c)
{
    int letra;
    c = toupper(c);
    char* morse[] = {
        ".-","-...","-.-.","-..", ".", "..-.",
        "--.","....", "..", ".---", "-.-", ".-..", "--","-.",
        "---", ".--.", "--.-", ".-.", "...", "-","..-", "...-",
        ".--", "-..-", "-.--", "--.."
    };

    letra = (int)(c - 'A');

    // Caracter não reconhecido. Pisca erro
    if (letra >= 26 || letra < 0) {
        piscaErro(DOT);
        return NULL;
    }

    return morse[letra];
}

void piscaMorse(char letra)
{
    int i;
    char *code = (char*)malloc(sizeof (*code));

    strcpy(code, charToMorse(letra));
    for(i = 0; i < strlen(code); i++) {
        if(code[i] == '.')
            pisca(DOT);
        else if(code[i] == '-')
            pisca(DASH);
    }
}

void txtMorse(char m[])
{
    int i;
    for(i = 0; i < strlen(m); i++) {
        piscaMorse(m[i]);
        wait(PAUSE*3); // Pause between letters
    }
}




int main()
{
    red = green = 1;
    while(1)
        txtMorse("augusto");
    //piscaMorse('B');
}



