/**    Hibernus Library
 *	   University of Southampton 2017
 *
 *		Open-source liberary that enable any of your Mbed project work with transient enegy sources.
 *		In order to use this library include the "hibernus.h" header file, and use the "Hibernus()" method at the beginning of you main funtion.
 *		For more details and example see the "main.cpp" exampe file, and the attached documnetation
 *
 *
 *     Released under the MIT License: http://mbed.org/license/mit
 */
#ifndef CONFIG_H_
#define CONFIG_H_
#ifdef LPC11U24
#include "mbed.h"
#include "IAP.h"

/////for LPC11U24
#define RAM_Start 0x10000000
#define FLASH_Start 0x00000000
#define RAM_Size 8192
#define flash_Size  32768               //32K flash
#define sector_Size FLASH_SECTOR_SIZE       //4K sector size

#define No_Of_4B_Peripheral_Reg 10
#define No_Of_1B_Peripheral_Reg 0

const unsigned int REG_Addresses_4B[83] = {
(unsigned int)&LPC_GPIO_PIN_INT->ISEL,                    /*!< (@ 0x4004C000) Pin Interrupt Mode register */
(unsigned int)&LPC_GPIO_PIN_INT->IENR,                       /*!< (@ 0x4004C004) Pin Interrupt Enable (Rising) register */
(unsigned int)&LPC_GPIO_PIN_INT->SIENR,                      /*!< (@ 0x4004C008) Set Pin Interrupt Enable (Rising) register */
(unsigned int)&LPC_GPIO_PIN_INT->CIENR,                      /*!< (@ 0x4004C00C) Clear Pin Interrupt Enable (Rising) register */
(unsigned int)&LPC_GPIO_PIN_INT->IENF,                       /*!< (@ 0x4004C010) Pin Interrupt Enable Falling Edge / Active Level register */
(unsigned int)&LPC_GPIO_PIN_INT->SIENF,                      /*!< (@ 0x4004C014) Set Pin Interrupt Enable Falling Edge / Active Level register */
(unsigned int)&LPC_GPIO_PIN_INT->CIENF,                      /*!< (@ 0x4004C018) Clear Pin Interrupt Enable Falling Edge / Active Level address */
(unsigned int)&LPC_GPIO_PIN_INT->RISE,                       /*!< (@ 0x4004C01C) Pin Interrupt Rising Edge register */
(unsigned int)&LPC_GPIO_PIN_INT->FALL,                       /*!< (@ 0x4004C020) Pin Interrupt Falling Edge register */
(unsigned int)&LPC_GPIO_PIN_INT->IST,
};
 
const unsigned int REG_Addresses_1B[30] = {}; 

#if HasInternalComparator == 1
	void configure_VR_comparator_interrupt(void);
  void configure_VH_comparator_interrupt(void);
	void Comparator_Setup(void);
#else
	extern "C" void FLEX_INT0_IRQHandler(void);
	extern "C" void FLEX_INT1_IRQHandler(void);
  void configure_VH_gpio_interrupt(void);
  void configure_VR_gpio_interrupt(void);
#endif
	
void erase_flags_memory(void);
void restore_flags(void);
void Enter_LLS(void);
void setFlag(volatile unsigned int*);
bool isFlagSet(volatile unsigned int*);
void copyRamToFlash(void);

#endif
#endif
	