/**    Hibernus Library
 *	   University of Southampton 2017
 *
 *		Open-source liberary that enable any of your Mbed project work with transient enegy sources.
 *		In order to use this library include the "hibernus.h" header file, and use the "Hibernus()" method at the beginning of you main funtion.
 *		For more details and example see the "main.cpp" exampe file, and the attached documnetation
 *
 *
 *     Released under the MIT License: http://mbed.org/license/mit
 */
#ifdef LPC11U24
#include "Driver_LPC11U24.h"
#include "hibernus.h"
#include "config.h"

IAP iap;
Serial pc1(USBTX, USBRX);

void Enter_LLS(){
	configure_VR_gpio_interrupt();
	
	LPC_PMU->PCON |= 0x1;
	LPC_SYSCON->PINTSEL[0] = 0x02;												//configure pin P0_2 as interupt source 
	LPC_SYSCON->PDRUNCFG &= ~(1<<1);
	LPC_SYSCON->STARTERP0 |= (1<<0);											//Config chanel as wake up interrupt
	LPC_SYSCON->PDAWAKECFG &= ~((1<<0)|(1<<1)|(1<<2)|(1<<5)|(1<<7));	//wake up all needed modules after recovering from deepslep mode
	NVIC_SetPriority(FLEX_INT0_IRQn,0);
	NVIC_EnableIRQ(FLEX_INT0_IRQn);
	NVIC_SetPriority(FLEX_INT0_IRQn,0);
	
	//Go to deep Sleep mode ---->
	SCB->SCR |= SCB_SCR_SLEEPDEEP_Msk;										//choose Deep Sleep as power mode
	__WFI();    																					// Stop executing instructions and enter Deep Sleep mode
}

//if there is no internal Coomparator define 2 GPIO interrupts to wake up and sleep

void configure_VR_gpio_interrupt(){
	LPC_GPIO->DIR[0] |= 1<<2;										//set pin P0_2 as input	//generate interrupt for VR

	LPC_SYSCON->SYSAHBCLKCTRL |= (1<<6);	
	LPC_SYSCON->SYSAHBCLKCTRL |= (1<<16);
	LPC_IOCON->PIO0_2 = (0x0|(0x2<<3));					//enable pullup
	LPC_SYSCON->SYSAHBCLKCTRL |= (1<<19); 			//System enable peripheral clock		
	LPC_SYSCON->PINTSEL[0] = 0x2;								//configure interrupt chanel for the GPIO pin is syscon block

	LPC_GPIO_PIN_INT->ISEL &= ~(1<<0);					//set the interrupt mode for the pin0 to be Level Sensitive
	LPC_GPIO_PIN_INT->IENF |= (1<<0);						//enable the level sensitive interrupt on pin P0_2
		
	LPC_SYSCON->STARTERP0 |= (1<<0);						//config chanel as wake up interrupt is Syscon block
		
	__enable_irq();
	NVIC_EnableIRQ(FLEX_INT0_IRQn);
	NVIC_SetPriority(FLEX_INT0_IRQn,0);					//Set a higher prioroty for wake up interrupt, to be able to interrupt the sleep interrupt
}

void configure_VH_gpio_interrupt(){
	LPC_GPIO->DIR[0] |= 1<<8;										//set pin P0_8 as input //generate interrupt for VH
	
	LPC_SYSCON->SYSAHBCLKCTRL |= (1<<6);	
	LPC_SYSCON->SYSAHBCLKCTRL |= (1<<16);
	LPC_IOCON->PIO0_8 = (0x0|(0x2<<3));					//choose first pin function and enable pullup
	LPC_SYSCON->SYSAHBCLKCTRL |= (1<<19); 			//System enable peripheral clock		
	LPC_SYSCON->PINTSEL[1] = (uint32_t)8;				//configure interrupt chanel for the GPIO pin is syscon block
	
	LPC_GPIO_PIN_INT->ISEL &= ~(1<<1);					//set the interrupt mode for the pin1 to be Level Sensitive
	LPC_GPIO_PIN_INT->IENF |= (1<<1);						//enable the level sensitive interrupt on pin P0_8
	
	__enable_irq();
	NVIC_EnableIRQ(FLEX_INT1_IRQn);
	NVIC_SetPriority(FLEX_INT1_IRQn,2);					//Set a lower priority for the sleep interrupt, in order to be possible for the wake up interrupt to interrupt it
}

//the interrupt triggered by the GPIO/INternal Comparator where the snapshot is saved
extern "C" void FLEX_INT1_IRQHandler(){   //To make sure the compiler sees handler, need to declare it as extern (https://developer.mbed.org/forum/mbed/topic/419/?page=1#comment-2126)
	pc1.printf(" ",isFlagSet(getFlag_1()),isFlagSet(getFlag_2()),isFlagSet(getFlag_3()),isFlagSet(getFlag_4())); 

  hibernate((_SP+0x40),*(unsigned int*)(_SP+0x34),*(unsigned int*)(_SP+0x38));
		
		//clear interupt status register
		LPC_GPIO_PIN_INT->IST |=((1<<0)|(1<<1));
		//delete any sleep interupts that came during the sleep
		NVIC_ClearPendingIRQ(FLEX_INT1_IRQn);
}

//ISR for wakeing up the core and seting the interrupt for Hibernate procedure 
extern "C" void FLEX_INT0_IRQHandler(){   //To make sure the compiler sees handler, need to declare it as extern (https://developer.mbed.org/forum/mbed/topic/419/?page=1#comment-2126)
	NVIC_ClearPendingIRQ(FLEX_INT0_IRQn);
	
	recovery_no_power_loss();								//check if you are recovering after no power loss, and if so, configure VH interrupt
	
	//clear interupt status register
	LPC_GPIO_PIN_INT->IST |= (1<<0);
}

//used to restore the flags values from Flash to RAM
void restore_flags(){
	if(!SaveFlagsInFlash){
		*getFlag_1() = *(unsigned int*)(flash_ramSection_start+Fixed_Add_Vars_Offset);
		*getFlag_2() = *(unsigned int*)(flash_ramSection_start+Fixed_Add_Vars_Offset+0x4);
		*getFlag_3() = *(unsigned int*)(flash_ramSection_start+Fixed_Add_Vars_Offset+0x8);
		*getFlag_4() = *(unsigned int*)(flash_ramSection_start+Fixed_Add_Vars_Offset+0xC);
	}
}

//mark a flag as "SET"
void setFlag(volatile unsigned int* add){
	#if SaveFlagsInFlash == 1
		const unsigned int set = Flag_set;
		program_flash(*add,(char*)&set,4);			//if the flags are stored in flash, use this line
	#else
		*add = Flag_set;
	#endif
	
}

//check if a flag is SET or CLEAR
bool isFlagSet(volatile unsigned int* add){
	#if SaveFlagsInFlash == 1
		if( *(unsigned int *)(*add) == Flag_set) return true;
		return false;
	#else
		if(*add == Flag_set ) return true;
		return false;
	#endif
}

//Clear the memory area where the flags are saved
void erase_flags_memory(){
	#if SaveFlagsInFlash == 0				//if the flags are stored in RAM, their value have to be clanged to the "erased" value ("Flag_erase")
    *getFlag_1() = Flag_erase;
    *getFlag_2() = Flag_erase;
    *getFlag_3() = Flag_erase;
    *getFlag_4() = Flag_erase;
	#else												//if the flags are stored in Flash, their secvtor have to be erased
		erase_sector(Flash_Flags_Sector_Start);
	#endif
}

//copy the whole content of RAM into the flash
void copyRamToFlash(){
	// Erase flash sectors o save the RAM content
	int g3=iap.prepare(6,7);
	int g4=iap.erase(6,7);
	
  // Copy all the RAM to flash
  int g0 = iap.prepare(6,7);
	int g1=iap.write((char*)RAM_Start,(char*)flash_ramSection_start,RAM_Size/2);
			g1+=iap.write((char*)RAM_Start+(RAM_Size/2),(char*)flash_ramSection_start+(RAM_Size/2),(RAM_Size/2));
}
#endif