#ifndef CONFIG_H_
#define CONFIG_H_
#ifdef KL05Z
#include "mbed.h"
#include "FreescaleIAP.h"

#define HasInternalComparator 1							//Set on 1 if there is an internal comparator 0 otherwise
#define SaveFlagsInFlash	1									//set on 1 if there is enough Flash memory available for the flags to have their own flash sector, 0 otherwise
																						//if there is not enough flash memory, the flags will be saved in RAM memory

// RAM addresses split in 1 KB sectors
#define RAM_Start  0x1FFFFC00
#define FLASH_Start 0x00000000
#define RAM_Size 4096
#define flash_Size flash_size()				//32K flash
#define sector_Size SECTOR_SIZE				//4K sector size
#define Flash_Flags_Sector_Start (flash_end -1*sector_Size)

#define No_Of_4B_Peripheral_Reg 18
#define No_Of_1B_Peripheral_Reg 8

const unsigned int REG_Addresses_4B[83] =     // Constant peripheral register addresses which are 4 bytes in size
    {
		(unsigned int)&FPTA->PDOR,(unsigned int)&FPTA->PDDR,(unsigned int)&FPTB->PDOR,(unsigned int)&FPTB->PDDR,
		 //0x4000F000, 0x4000F014, 0x4000F040, 0x4000F054,    // GPIO controller aliased to ox400FF000
		(unsigned int)&SIM->SOPT1,(unsigned int)&SIM->SOPT1CFG,(unsigned int)&SIM->SOPT2,(unsigned int)&SIM->SOPT4,
		(unsigned int)&SIM->SOPT5,(unsigned int)&SIM->SOPT7,(unsigned int)&SIM->SCGC4,(unsigned int)&SIM->SCGC5,
		(unsigned int)&SIM->SCGC6,(unsigned int)&SIM->SCGC7,(unsigned int)&SIM->CLKDIV1,(unsigned int)&SIM->FCFG1,
		(unsigned int)&SIM->COPC,
     //0x40047000, 0x40047004, 0x40048004, 0x4004800C, 0x40048010, 0x40048018, 0x40048034, 0x40048038, 0x4004803C, 0x40048040,
     //0x40048044, 0x4004804C, 0x40048100,    // SIM
		(unsigned int)&PORTA->PCR[0],(unsigned int)&PORTA->PCR[1],(unsigned int)&PORTA->PCR[2],(unsigned int)&PORTA->PCR[3],
		(unsigned int)&PORTA->PCR[4],(unsigned int)&PORTA->PCR[5],(unsigned int)&PORTA->PCR[6],(unsigned int)&PORTA->PCR[7],
		(unsigned int)&PORTA->PCR[8],(unsigned int)&PORTA->PCR[9],(unsigned int)&PORTA->PCR[10],(unsigned int)&PORTA->PCR[11],
		(unsigned int)&PORTA->PCR[12],(unsigned int)&PORTA->PCR[13],(unsigned int)&PORTA->PCR[14],(unsigned int)&PORTA->PCR[15],
		(unsigned int)&PORTA->PCR[16],(unsigned int)&PORTA->PCR[17],(unsigned int)&PORTA->PCR[18],(unsigned int)&PORTA->PCR[19],
		(unsigned int)&PORTA->PCR[20],(unsigned int)&PORTA->PCR[21],(unsigned int)&PORTA->PCR[22],(unsigned int)&PORTA->PCR[23],
		(unsigned int)&PORTA->PCR[24],(unsigned int)&PORTA->PCR[25],(unsigned int)&PORTA->PCR[26],(unsigned int)&PORTA->PCR[27],
		(unsigned int)&PORTA->PCR[28],(unsigned int)&PORTA->PCR[29],(unsigned int)&PORTA->PCR[30],(unsigned int)&PORTA->PCR[31],
     //0x40049000, 0x40049004, 0x40049008, 0x4004900C, 0x40049010, 0x40049014, 0x40049018, 0x4004901C, 0x40049020, 0x40049024,
     //0x40049028, 0x4004902C, 0x40049030, 0x40049034, 0x40049038, 0x4004903C, 0x40049040, 0x40049044, 0x40049048, 0x4004904C,
     //0x40049050, 0x40049054, 0x40049058, 0x4004905C, 0x40049060, 0x40049064, 0x40049068, 0x4004906C, 0x40049070, 0x40049074,
     //0x40049078, 0x4004907C,    // Port A multiplexing control
		(unsigned int)&PORTB->PCR[0],(unsigned int)&PORTB->PCR[1],(unsigned int)&PORTB->PCR[2],(unsigned int)&PORTB->PCR[3],
		(unsigned int)&PORTB->PCR[4],(unsigned int)&PORTB->PCR[5],(unsigned int)&PORTB->PCR[6],(unsigned int)&PORTB->PCR[7],
		(unsigned int)&PORTB->PCR[8],(unsigned int)&PORTB->PCR[9],(unsigned int)&PORTB->PCR[10],(unsigned int)&PORTB->PCR[11],
		(unsigned int)&PORTB->PCR[12],(unsigned int)&PORTB->PCR[13],(unsigned int)&PORTB->PCR[14],(unsigned int)&PORTB->PCR[15],
		(unsigned int)&PORTB->PCR[16],(unsigned int)&PORTB->PCR[17],(unsigned int)&PORTB->PCR[18],(unsigned int)&PORTB->PCR[19],
		(unsigned int)&PORTB->PCR[20],(unsigned int)&PORTB->PCR[21],(unsigned int)&PORTB->PCR[22],(unsigned int)&PORTB->PCR[23],
		(unsigned int)&PORTB->PCR[24],(unsigned int)&PORTB->PCR[25],(unsigned int)&PORTB->PCR[26],(unsigned int)&PORTB->PCR[27],
		(unsigned int)&PORTB->PCR[28],(unsigned int)&PORTB->PCR[29],(unsigned int)&PORTB->PCR[30],(unsigned int)&PORTB->PCR[31],
     //0x4004A000, 0x4004A004, 0x4004A008, 0x4004A00C, 0x4004A010, 0x4004A014, 0x4004A018, 0x4004A01C, 0x4004A020, 0x4004A024,
     //0x4004A028, 0x4004A02C, 0x4004A030, 0x4004A034, 0x4004A038, 0x4004A03C, 0x4004A040, 0x4004A044, 0x4004A048, 0x4004A04C,
     //0x4004A050, 0x4004A054, 0x4004A058, 0x4004A05C, 0x4004A060, 0x4004A064, 0x4004A068, 0x4004A06C, 0x4004A070, 0x4004A074,
     //0x4004A078, 0x4004A07C,    // Port B multiplexing control
		(unsigned int)&MCM->PLACR,(unsigned int)&MCM->CPO
     //0xF000300C, 0xF0003040			// MCM
		};    
 
const unsigned int REG_Addresses_1B[30] =     // Constant peripheral register addresses which are 1 byte in size
    {
		(unsigned int)&MCG->C1,(unsigned int)&MCG->C2,(unsigned int)&MCG->C3,(unsigned int)&MCG->C4,
		(unsigned int)&MCG->C6,(unsigned int)&MCG->SC,(unsigned int)&MCG->ATCVH,(unsigned int)&MCG->ATCVL,
			//0x40064000, 0x40064001, 0x40064002, 0x40064003, 0x40064005, 0x40064008, 0x4006400A, 0x4006400B,    // MCG
    (unsigned int)&OSC0->CR,
			//0x40065000,    // Oscillator
		(unsigned int)&UART0->BDH,(unsigned int)&UART0->BDL,(unsigned int)&UART0->C1,(unsigned int)&UART0->C2,
		(unsigned int)&UART0->S1,(unsigned int)&UART0->S2,(unsigned int)&UART0->C3,(unsigned int)&UART0->D,
		(unsigned int)&UART0->MA1,(unsigned int)&UART0->MA2,(unsigned int)&UART0->C4,(unsigned int)&UART0->C5,
     //0x4006A000, 0x4006A001, 0x4006A002, 0x4006A003, 0x4006A004, 0x4006A005, 0x4006A006, 0x4006A007, 0x4006A008, 0x4006A009,
     //0x4006A00A, 0x4006A00B,    // UART0
		(unsigned int)&PMC->LVDSC1,(unsigned int)&PMC->LVDSC2,(unsigned int)&PMC->REGSC,
     //0x4007D000, 0x4007D001, 0x4007D002,    // PMC
		(unsigned int)&SMC->PMPROT,(unsigned int)&SMC->PMCTRL,(unsigned int)&SMC->STOPCTRL,(unsigned int)&SMC->PMSTAT,
     //0x4007E000, 0x4007E001, 0x4007E002, 0x4007E003,   // SMC
		(unsigned int)&RCM->RPFC,(unsigned int)&RCM->RPFW
     //0x4007F004, 0x4007F005 // RCM
		};

#if HasInternalComparator == 1
	void configure_VR_comparator_interrupt(void);
  void configure_VH_comparator_interrupt(void);
	void Comparator_Setup(void);
#else
	extern "C" void FLEX_INT0_IRQHandler(void);
	extern "C" void FLEX_INT1_IRQHandler(void);
  void configure_VH_gpio_interrupt(void);
  void configure_VR_gpio_interrupt(void);
#endif

void erase_flags_memory(void);
void restore_flags(void);
void Enter_LLS(void);
void setFlag(volatile unsigned int*);
bool isFlagSet(volatile unsigned int*);
void copyRamToFlash(void);

#endif
#endif
